package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclCustomerFortunePay;
import com.yd.dal.mapper.customer.AclCustomerFortunePayMapper;
import com.yd.dal.service.customer.AclCustomerFortunePayDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxy
 */
@Service("aclCustomerFortunePayDALService")
public class AclCustomerFortunePayDALServiceImpl implements AclCustomerFortunePayDALService {

    @Autowired
    private AclCustomerFortunePayMapper customerFortunePayMapper;

    @Override
    public List<AclCustomerFortunePay> findByWithdrawIds(List<Long> withdrawIds) {
        return customerFortunePayMapper.findByWithdrawIds(withdrawIds);
    }

    @Override
    public void updateAll(List<AclCustomerFortunePay> pays) {
        customerFortunePayMapper.updateBatch(pays);
    }

    @Override
    public Long save(AclCustomerFortunePay pay) {
        return (long)customerFortunePayMapper.insert(pay);
    }
}
