package com.yd.dal.service.customer;

import com.yd.api.practitioner.vo.recruit.PractitionerPotentialInfo;
import com.yd.dal.entity.customer.AclPractitionerPotential;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclPractitionerPotentialDALService")
public interface AclPractitionerPotentialDALService {
    /**
     * 根据手机号查询
     * @param mobileNo
     * @return
     */
    List<AclPractitionerPotential> findByMobileNo(String mobileNo,Integer isActive);

    /**
     * 保存
     * @param practitionerPotential
     * @return
     */
    int update(AclPractitionerPotential practitionerPotential);

    /**
     * 查询该团队长对于每个增员最新的记录
     * @param practitionerId
     * @return
     */
    List<PractitionerPotentialInfo> findByPractitionerIdAndLasted(Long practitionerId);
}
