package com.yd.dal.service.customer.impl;

import com.google.common.base.Strings;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.customer.practitioner.AclPractitionerInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerRankInfo;
import com.yd.dal.mapper.customer.AclPractitionerMapper;
import com.yd.dal.service.customer.AclPractitionerDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
@Service("aclPractitionerDALService")
public class AclPractitionerDALServiceImpl implements AclPractitionerDALService {
    private static final Logger LOG = Logger.getLogger(AclPractitionerDALServiceImpl.class);
    @Resource
    private AclPractitionerMapper aclPractitionerMapper;
    @Override
    public AclPractitioner findByCustomerIdIsActive(Long customerId, int isActive) {
        return aclPractitionerMapper.findByCustomerIdIsActive(customerId,isActive);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public PractitionerBasicInfo getPractitionerBasicInfoForOffline(String mobileNo) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            return aclPractitionerMapper.getPractitionerInfoByMobileNoForOffline(mobileNo);
        }else{
            LOG.error("mobileNo is null！");
        }
        return null;
    }

    @Override
    public PractitionerBasicInfo getPractitionerBasicInfoForOnline(String mobileNo) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            return aclPractitionerMapper.getPractitionerInfoByMobileNoForOnline(mobileNo);
        }else{
            LOG.error("mobileNo is null！");
        }
        return null;
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time) {
        return aclPractitionerMapper.getPractitionerRankInfoForOffline(time);
    }

    @Override
    public List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time,Long practitionerTypeId) {
        return aclPractitionerMapper.getPractitionerRankInfoForOnline(time,practitionerTypeId);
    }

    @Override
    public List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(List<String> mobileSpecials,Integer time) {
        return aclPractitionerMapper.getPractitionerRankInfoForSpecials(mobileSpecials,time);
    }

    @Override
    public PractitionerInfo findPractitionerInfoByLogin(String mobileNo) {
        return aclPractitionerMapper.findPractitionerInfoByLogin(mobileNo);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)
    public AclPractitioner findPractitionerById(Long practitionerId) {
        return aclPractitionerMapper.selectByPrimaryKey(practitionerId);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)
    public void updatePractitioner(AclPractitioner practitioner) {
        aclPractitionerMapper.updateByPrimaryKeySelective(practitioner);
    }

    @Override
    public List<AclPractitioner> findByIds(List<Long> practitionerIdList) {
        return aclPractitionerMapper.findByIds(practitionerIdList);
    }
}
