package com.yd.api.practitioner;

import com.yd.api.practitioner.service.PractitionerArticleService;
import com.yd.api.practitioner.vo.ArticleTrackSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveRequestVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleTrackQueryResponseVO;
import com.yd.api.practitioner.vo.article.ArticleTrackSaveRequestVO;
import com.yd.api.result.JsonResult;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@RestController
@RequestMapping("/practitionerArticle")
public class PractitionerArticleController {
    @Autowired
    private PractitionerArticleService practitionerArticleService;

    /**
     * 分享文章保存
     */
    @RequestMapping("/articleShareCodeSave")
    public Object articleShareCodeSave(@RequestBody ArticleShareCodeSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        System.out.println("分享文章保存");
        System.out.println(requestVO.toString());
        ArticleShareCodeSaveResponseVO responseVO = practitionerArticleService.articleShareCodeSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 客户文章跟踪信息保存
     */
    @RequestMapping("/articleTrackSave")
    public Object articleTrackSave(@RequestBody ArticleTrackSaveRequestVO requestVO){
        System.out.println("客户文章跟踪信息保存");
        System.out.println(requestVO.toString());
        JsonResult result = new JsonResult();
        ArticleTrackSaveResponseVO responseVO = practitionerArticleService.articleTrackSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 客户文章跟踪信息查询
     */
    @RequestMapping(value = "/articleTrackQuery",method = RequestMethod.GET)
    public Object articleTrackQuery(@RequestParam("practitionerId") Long practitionerId,
                                    @RequestParam("sharingId") Long sharingId ){
        System.out.println("客户文章跟踪信息查询");
        JsonResult result = new JsonResult();
        ArticleTrackQueryResponseVO responseVO = practitionerArticleService.articleTrackQuery(practitionerId,sharingId);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
}
