package com.yd.dal.entity.agms.fortune;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author xxy
 */
public class FortunePayToOrderInfo {
    /**
     * 保险公司
     */
    private String insurerName;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 保费
     */
    private BigDecimal orderPrice;

    /**
     * 佣金类型
     */
    private String commissionType;

    /**
     * 应发佣率
     */
    private BigDecimal referralRate;

    /**
     * 应发金额
     */
    private BigDecimal referralAmount;

    /**
     * 购买方案
     */
    private String productName;

    /**
     * 预计发佣年月
     */
    private String payoutYearmonth;

    /**
     * 经纪人
     */
    private String practitionerName;

    /**
     * 佣金
     */
    private BigDecimal commissionAmount;

    /**
     * 佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 发佣状态
     */
    private String commissionPayoutStatus;

    /**
     * 手机号
     */
    private String mobileNo;

    /**
     * 经纪人职级
     */
    private String practitionerLevel;

    /**
     * 分公司
     */
    private String insurerBranchName;

    /**
     * 营业部
     */
    private String insurerBranchDeptName;

    /**
     * 体系
     */
    private String subordinateSystemName;

    /**
     * fyc
     */
    private BigDecimal fycAmount;

    /**
     * 渠道名称
     */
    private String channelName;
    /**
     * 渠道联系人手机号
     */
    private String contactPhone;


    /**
     * 获取 保险公司
     *
     * @return the insurerName 保险公司
     */
    public String getInsurerName() {
        return this.insurerName;
    }

    /**
     * 设置 保险公司
     *
     * @param insurerName the 保险公司 to set
     */
    public void setInsurerName(String insurerName) {
        this.insurerName = insurerName;
    }

    /**
     * 获取 保单号
     *
     * @return the policyNo 保单号
     */
    public String getPolicyNo() {
        return this.policyNo;
    }

    /**
     * 设置 保单号
     *
     * @param policyNo the 保单号 to set
     */
    public void setPolicyNo(String policyNo) {
        this.policyNo = policyNo;
    }

    /**
     * 获取 保费
     *
     * @return the orderPrice 保费
     */
    public BigDecimal getOrderPrice() {
        return this.orderPrice;
    }

    /**
     * 设置 保费
     *
     * @param orderPrice the 保费 to set
     */
    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    /**
     * 获取 佣金类型
     *
     * @return the commissionType 佣金类型
     */
    public String getCommissionType() {
        return this.commissionType;
    }

    /**
     * 设置 佣金类型
     *
     * @param commissionType the 佣金类型 to set
     */
    public void setCommissionType(String commissionType) {
        this.commissionType = commissionType;
    }

    /**
     * 获取 应发佣率
     *
     * @return the referralRate 应发佣率
     */
    public BigDecimal getReferralRate() {
        return this.referralRate;
    }

    /**
     * 设置 应发佣率
     *
     * @param referralRate the 应发佣率 to set
     */
    public void setReferralRate(BigDecimal referralRate) {
        this.referralRate = referralRate;
    }

    /**
     * 获取 应发金额
     *
     * @return the referralAmount 应发金额
     */
    public BigDecimal getReferralAmount() {
        return this.referralAmount;
    }

    /**
     * 设置 应发金额
     *
     * @param referralAmount the 应发金额 to set
     */
    public void setReferralAmount(BigDecimal referralAmount) {
        this.referralAmount = referralAmount;
    }

    /**
     * 获取 购买方案
     *
     * @return the productName 购买方案
     */
    public String getProductName() {
        return this.productName;
    }

    /**
     * 设置 购买方案
     *
     * @param productName the 购买方案 to set
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 预计发佣年月
     *
     * @return the payoutYearmonth 预计发佣年月
     */
    public String getPayoutYearmonth() {
        return this.payoutYearmonth;
    }

    /**
     * 设置 预计发佣年月
     *
     * @param payoutYearmonth the 预计发佣年月 to set
     */
    public void setPayoutYearmonth(String payoutYearmonth) {
        this.payoutYearmonth = payoutYearmonth;
    }

    /**
     * 获取 经纪人
     *
     * @return the practitionerName 经纪人
     */
    public String getPractitionerName() {
        return this.practitionerName;
    }

    /**
     * 设置 经纪人
     *
     * @param practitionerName the 经纪人 to set
     */
    public void setPractitionerName(String practitionerName) {
        this.practitionerName = practitionerName;
    }

    /**
     * 获取 佣金
     *
     * @return the commissionAmount 佣金
     */
    public BigDecimal getCommissionAmount() {
        return this.commissionAmount;
    }

    /**
     * 设置 佣金
     *
     * @param commissionAmount the 佣金 to set
     */
    public void setCommissionAmount(BigDecimal commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /**
     * 获取 佣金率
     *
     * @return the commissionRate 佣金率
     */
    public BigDecimal getCommissionRate() {
        return this.commissionRate;
    }

    /**
     * 设置 佣金率
     *
     * @param commissionRate the 佣金率 to set
     */
    public void setCommissionRate(BigDecimal commissionRate) {
        this.commissionRate = commissionRate;
    }

    /**
     * 获取 发佣状态
     *
     * @return the commissionPayoutStatus 发佣状态
     */
    public String getCommissionPayoutStatus() {
        return this.commissionPayoutStatus;
    }

    /**
     * 设置 发佣状态
     *
     * @param commissionPayoutStatus the 发佣状态 to set
     */
    public void setCommissionPayoutStatus(String commissionPayoutStatus) {
        this.commissionPayoutStatus = commissionPayoutStatus;
    }

    /**
     * 获取 手机号
     *
     * @return the mobileNo 手机号
     */
    public String getMobileNo() {
        return this.mobileNo;
    }

    /**
     * 设置 手机号
     *
     * @param mobileNo the 手机号 to set
     */
    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    /**
     * 获取 经纪人职级
     *
     * @return the practitionerLevel 经纪人职级
     */
    public String getPractitionerLevel() {
        return this.practitionerLevel;
    }

    /**
     * 设置 经纪人职级
     *
     * @param practitionerLevel the 经纪人职级 to set
     */
    public void setPractitionerLevel(String practitionerLevel) {
        this.practitionerLevel = practitionerLevel;
    }

    /**
     * 获取 分公司
     *
     * @return the insurerBranchName 分公司
     */
    public String getInsurerBranchName() {
        return this.insurerBranchName;
    }

    /**
     * 设置 分公司
     *
     * @param insurerBranchName the 分公司 to set
     */
    public void setInsurerBranchName(String insurerBranchName) {
        this.insurerBranchName = insurerBranchName;
    }

    /**
     * 获取 营业部
     *
     * @return the insurerBranchDeptName 营业部
     */
    public String getInsurerBranchDeptName() {
        return this.insurerBranchDeptName;
    }

    /**
     * 设置 营业部
     *
     * @param insurerBranchDeptName the 营业部 to set
     */
    public void setInsurerBranchDeptName(String insurerBranchDeptName) {
        this.insurerBranchDeptName = insurerBranchDeptName;
    }

    /**
     * 获取 体系
     *
     * @return the subordinateSystemName 体系
     */
    public String getSubordinateSystemName() {
        return this.subordinateSystemName;
    }

    /**
     * 设置 体系
     *
     * @param subordinateSystemName the 体系 to set
     */
    public void setSubordinateSystemName(String subordinateSystemName) {
        this.subordinateSystemName = subordinateSystemName;
    }

    /**
     * 获取 fyc
     *
     * @return the fycAmount fyc
     */
    public BigDecimal getFycAmount() {
        return this.fycAmount;
    }

    /**
     * 设置 fyc
     *
     * @param fycAmount the fyc to set
     */
    public void setFycAmount(BigDecimal fycAmount) {
        this.fycAmount = fycAmount;
    }
    
	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	public String getContactPhone() {
		return contactPhone;
	}

	public void setContactPhone(String contactPhone) {
		this.contactPhone = contactPhone;
	}

	@Override
    public String toString() {
        return "FortunePayToOrderInfo{" +
                "insurerName='" + insurerName + '\'' +
                ", policyNo='" + policyNo + '\'' +
                ", orderPrice=" + orderPrice +
                ", commissionType='" + commissionType + '\'' +
                ", referralRate=" + referralRate +
                ", referralAmount=" + referralAmount +
                ", productName='" + productName + '\'' +
                ", payoutYearmonth='" + payoutYearmonth + '\'' +
                ", practitionerName='" + practitionerName + '\'' +
                ", commissionAmount=" + commissionAmount +
                ", commissionRate=" + commissionRate +
                ", commissionPayoutStatus='" + commissionPayoutStatus + '\'' +
                ", mobileNo='" + mobileNo + '\'' +
                ", practitionerLevel='" + practitionerLevel + '\'' +
                ", insurerBranchName='" + insurerBranchName + '\'' +
                ", insurerBranchDeptName='" + insurerBranchDeptName + '\'' +
                ", subordinateSystemName='" + subordinateSystemName + '\'' +
                ", fycAmount=" + fycAmount +
                ", channelName=" + channelName +
                ", contactPhone=" + contactPhone +
                '}';
    }
}

