package com.yd.api.metadata.service.impl;

import com.yd.api.metadata.service.MetadataService;
import com.yd.api.metadata.vo.TagQueryInfo;
import com.yd.api.metadata.vo.TagQueryResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.meta.MdTagNew;
import com.yd.dal.service.meta.MdTagNewDALService;
import com.yd.dal.service.metadata.MetadataDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author xxy
 * @date 2021年06月21日 17:33
 */
@Service("metadataService")
public class MetadataServiceImpl implements MetadataService {

    @Autowired
    public MetadataDALService metadataDalService;

    @Autowired
    public MdTagNewDALService mdTagNewDalService;

    @Override
    @SuppressWarnings("unchecked")
    public TagQueryResponseVO tagQuery(Long isActive) {
        TagQueryResponseVO responseVO = new TagQueryResponseVO();

        List<MdTagNew> mdTagNewList = mdTagNewDalService.selectByIsActive(isActive);
        List<TagQueryInfo> tagQueryInfos = new ArrayList<>(16);
        List<MdTagNew> mdTagNewAddList = new ArrayList<>(16);

        BeanPropertyValueEqualsPredicate predicateClause = new BeanPropertyValueEqualsPredicate( "configLevel", 1L);
        List<MdTagNew> objectListSelect= (List<MdTagNew>) CollectionUtils.select(mdTagNewList, predicateClause);
        mdTagNewAddList.addAll(objectListSelect);
        classificationBuildUpMdTag(mdTagNewList,mdTagNewAddList,objectListSelect,tagQueryInfos);

        mdTagNewList.removeAll(mdTagNewAddList);
        uncategorizedMdTag(mdTagNewList,tagQueryInfos);

        responseVO.setTagQueryInfos(tagQueryInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @SuppressWarnings("unchecked")
    private void classificationBuildUpMdTag(List<MdTagNew> mdTagNewList,
                                            List<MdTagNew> mdTagNewAddList,
                                            List<MdTagNew> objectListSelect,
                                            List<TagQueryInfo> tagQueryInfos) {
        for (MdTagNew mdTagNew : objectListSelect) {
            Long id = mdTagNew.getId();
            TagQueryInfo tagQueryInfo = new TagQueryInfo();
            BeanUtils.copyProperties(mdTagNew,tagQueryInfo);
            tagQueryInfo.setCreatedAt(CommonUtil.dateParseString(mdTagNew.getCreatedAt(),"yyyy-MM-dd HH:mm:ss"));
            tagQueryInfo.setUpdatedAt(CommonUtil.dateParseString(mdTagNew.getUpdatedAt(),"yyyy-MM-dd HH:mm:ss"));
            BeanPropertyValueEqualsPredicate predicateClause = new BeanPropertyValueEqualsPredicate( "upperTagId", id);
            List<MdTagNew> mdTagNewListSelect= (List<MdTagNew>) CollectionUtils.select(mdTagNewList, predicateClause);
            if (mdTagNewListSelect.isEmpty()){
                tagQueryInfos.add(tagQueryInfo);
                continue;
            }
            mdTagNewAddList.addAll(mdTagNewListSelect);
            List<TagQueryInfo> tagQueryInfoList = new ArrayList<>(16);
            classificationBuildUpMdTag(mdTagNewList,mdTagNewAddList,mdTagNewListSelect,tagQueryInfoList);
            tagQueryInfoList.sort((o1, o2) -> o2.getId().compareTo(o1.getId()));
            tagQueryInfo.setTagQueryInfos(tagQueryInfoList);
            tagQueryInfos.add(tagQueryInfo);
        }
    }


    private void uncategorizedMdTag(List<MdTagNew> mdTagNewList, List<TagQueryInfo> tagQueryInfos) {
        TagQueryInfo tagQueryInfo = new TagQueryInfo();
        tagQueryInfo.setTagName("未分类");
        tagQueryInfo.setIsActive(1);
        tagQueryInfo.setCreatedAt(CommonUtil.dateParseString(new Date(),"yyyy-MM-dd HH:mm:ss"));
        tagQueryInfo.setCreatedBy(-1L);
        tagQueryInfo.setUpdatedAt(CommonUtil.dateParseString(new Date(),"yyyy-MM-dd HH:mm:ss"));
        tagQueryInfo.setUpdatedBy(-1L);
        List<TagQueryInfo> tagQueryInfoList = new ArrayList<>(16);
        mdTagNewList.forEach(m->{
            TagQueryInfo tagInfo = new TagQueryInfo();
            BeanUtils.copyProperties(m,tagInfo);
            tagInfo.setCreatedAt(CommonUtil.dateParseString(m.getCreatedAt(),"yyyy-MM-dd HH:mm:ss"));
            tagInfo.setUpdatedAt(CommonUtil.dateParseString(m.getUpdatedAt(),"yyyy-MM-dd HH:mm:ss"));
            tagQueryInfoList.add(tagInfo);
        });
        tagQueryInfoList.sort((o1, o2) -> o2.getId().compareTo(o1.getId()));
        tagQueryInfo.setTagQueryInfos(tagQueryInfoList);
        tagQueryInfos.add(tagQueryInfo);
    }
}
