package com.yd.rmi.tencent.wechatinterf.pojo.authorize;

/**
 * https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318590&token=&lang=zh_CN
 * 代公众号发起网页授权
	简介
		在公众号授权托管给第三方平台后，第三方平台可以根据本文档相关说明，代替授权公众号发起网页授权。关于OAuth2.0的详细介绍，可以参考OAuth2.0协议标准
		作为第三方平台开发商，需要拥有自己的appid以及secret（在创建第三方平台并获得审核成功后可以获取），以及确保授权的公众号具备授权作用域的权限，以及用于回调的域名。
	授权流程
		微信目前支持Authorization code授权模式，主要流程分为两步：
		1. 获取code
		2. 通过code换取accesstoken
 *
 */
public class AuthorizeRequest {
/*
	第一步：请求CODE
		请求方法
			在确保微信公众账号拥有授权作用域（scope参数）的权限的前提下（一般而言，已微信认证的服务号拥有snsapi_base和snsapi_userinfo），使用微信客户端打开以下链接（严格按照以下格式，包括顺序和大小写，并请将参数替换为实际内容）：
			https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE&component_appid=component_appid#wechat_redirect    
			若提示“该链接无法访问”，请检查参数是否填写错误，是否拥有scope参数对应的授权作用域权限。
		参数说明
			参数 是否必须 说明 
			appid 是 公众号的appid 
			redirect_uri 是 重定向地址，需要urlencode，这里填写的应是服务开发方的回调地址 
			response_type 是 填code 
			scope 是 授权作用域，拥有多个作用域用逗号（,）分隔 
			state 否 重定向后会带上state参数，开发者可以填写任意参数值，最多128字节 
			component_appid 是 服务方的appid，在申请创建公众号服务成功后，可在公众号服务详情页找到 
		返回说明
			用户允许授权后，将会重定向到redirect_uri的网址上，并且带上code, state以及appid
				redirect_uri?code=CODE&state=STATE&appid=APPID    
			若用户禁止授权，则重定向后不会带上code参数，仅会带上state参数
				redirect_uri?state=STATE
 */
	private String appid;
	private String redirect_uri;
	private String response_type;
	private String scope;
	private String state;
	private String component_appid;
	public String getAppid() {
		return appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}
	public String getRedirect_uri() {
		return redirect_uri;
	}
	public void setRedirect_uri(String redirect_uri) {
		this.redirect_uri = redirect_uri;
	}
	public String getResponse_type() {
		return response_type;
	}
	public void setResponse_type(String response_type) {
		this.response_type = response_type;
	}
	public String getScope() {
		return scope;
	}
	public void setScope(String scope) {
		this.scope = scope;
	}
	public String getState() {
		return state;
	}
	public void setState(String state) {
		this.state = state;
	}
	public String getComponent_appid() {
		return component_appid;
	}
	public void setComponent_appid(String component_appid) {
		this.component_appid = component_appid;
	}
}
