package com.yd.dal.service.agms;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.practitioner.*;

import java.util.List;
import java.util.Map;

/**
 * @author xxy
 */
public interface AgmsPractitionerDALService {

    /**
     *
     * @param mdDropOptionId 文章类型id
     * @param pageNum 当前页
     * @param size 每页的数量
     * @return 查询结果
     */
    PageInfo<PractitionerFileSharing> practitionerFileSharingList(Long id ,Long practitionerId,String shareCode,Long[] mdDropOptionId, Integer isActive, int pageNum, int size);

    SharePractitionerInfo findSharePractitioner(String shareCode);

    List<PractitionerScheduleInfo> practitionerSchedule(PractitionerScheduleRequestVO requestVO);

    List<PractitionerLeadsGoalsInfo> practitionerLeadsGoals(PractitionerLeadsGoalsRequestVO requestVO);

    List<Map<String, Object>> practitionerScheduleExport(PractitionerScheduleRequestVO requestVO);

    List<Map<String, Object>> practitionerLeadsGoalsExport(PractitionerLeadsGoalsRequestVO requestVO);

    List<PractitionerActivityInfo> practitionerActivity(PractitionerActivityRequestVO requestVO);

    List<Map<String, Object>> practitionerActivityExport(PractitionerActivityRequestVO requestVO);
}
