package com.yd.dal.service.marketing;

import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.statistics.LeadsStatisticsInfo;
import com.yd.dal.entity.marketing.MktLeadsPool;

public interface MktLeadsPoolDALService {
    MktLeadsPool findByCustomerId(Long customerId);

    void save(MktLeadsPool pool);

    List<LeadsStatisticsInfo> findByCondition(Integer isStatement,Integer leadsStatus,Integer expertApplyStatus,String leadsStartTime, String leadsEndTime);

    List<LeadsStatisticsInfo> findIsAssignLeads();

    Map<Long, Long> findLeadsStatusMap();

    PageInfo<LeadsStatisticsInfo> findByConditionPage(int pageNum, int size, Integer isStatement, Integer leadsStatus, Integer expertApplyStatus, String leadsStartTime, String leadsEndTime);
    
    void updateMktLeadsAssigneds(MktLeadsPool pool);

    MktLeadsPool findByCustomerIdForSfp(Long customerId);
    MktLeadsPool findBySfpMainId(Long sfpMainId);

}
