package com.yd.dal.mapper.agms;

import com.github.pagehelper.Page;
import com.yd.api.agms.vo.hiring.PractitionerHiringListRequestVO;
import com.yd.dal.entity.agms.hiring.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author xxy
 */
public interface AgmsHiringMapper {
    /**
     * 经纪人审批基本信息
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    PractitionerHiringBasicInfo findPractitionerHiringBasicInfo(Long hiringBasicInfoId);
    /**
     * 审批经纪人关系
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    PractitionerHiringMemberShip findPractitionerHiringMemberShip(Long hiringBasicInfoId);
    /**
     * 审批经纪人工作经历
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringWorkingExperience> findPractitionerHiringWorkingExperienceList(Long hiringBasicInfoId);
    /**
     * 经纪人申请名目
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringPersonalStatements> findPractitionerHiringPersonalStatementsList(Long hiringBasicInfoId);
    /**
     * 经纪人合同条款是否同意
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringContractTermsConfirms> findPractitionerHiringContractTermsConfirmsList(Long hiringBasicInfoId);
    /**
     * 已审批结果
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringApproveRecords> findPractitionerHiringApproveRecordsList(Long hiringBasicInfoId);

    /**
     * 通过loginId查询对应的经纪人id
     * @param loginId agms登入者id
     * @return 经纪人id
     */
    Long findPractitionerIdByLoginId(Long loginId);

    /**
     * 经纪人报聘列表查询
     * @param requestVO 查询条件
     * @return 列表结果
     */
    Page<PractitionerHiringListInfo> practitionerHiringList(PractitionerHiringListRequestVO requestVO);

    List<PractitionerHiringListInfo> queryHandledList(@Param("practitionerId")Long practitionerId,
                                                      @Param("status")String status,
                                                      @Param("branchId")Long branchId,
                                                      @Param("deptId")Long deptId,
                                                      @Param("subsystemIdList")List<Long> subsystemIdList,
                                                      @Param("name")String name
                                                      );

    Page<PractitionerHiringListInfo> queryUnhandledList(@Param("approveStatus")String approveStatus,
                                                        @Param("list")List<String> canAprroveGrades,
                                                        @Param("branchId")Long branchId,
                                                        @Param("deptId")Long deptId,
                                                        @Param("subsystemIdList")List<Long> subsystemIdList,
                                                        @Param("name")String name
                                                        );

    List<PractitionerHiringListInfo> queryS2List(@Param("approveStatus")String approveStatus);
}
