package com.yd.dataccess.service.customer;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.dataccess.entity.customer.Customer;
import com.yd.dataccess.entity.customer.CustomerFortune;
import com.yd.dataccess.mapper.customer.CustomerFortuneMapper;
import com.yd.dataccess.mapper.customer.CustomerMapper;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;

import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Simon
 * @version 1.0
 */
@Service("customerDAImpl")
public class CustomerDAImpl implements CustomerDA {

    private static final Logger LOG = Logger.getLogger(CustomerDAImpl.class);

    @Resource
    private CustomerMapper customerMapper;

    @Resource
    private CustomerFortuneMapper customerFortuneMapper;
    
	@Override
	@TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)
	public List<Customer> listAllCustomers() {
		PageHelper.startPage(1,10);
    	List<Customer> destList = new ArrayList<Customer>();

        destList = customerMapper.listAllCustomer();

        return destList;
	}
	/**
	 * 分页查询，指定页数，每页rows行数
	 */
    @Override
    public PageInfo<Customer> findByPage(int pageNo, int pageSize) {
    	String orderBy = "created_at desc";
    	
    	PageHelper.startPage(pageNo, pageSize, orderBy);
         
    	Page<Customer> destList = customerMapper.queryByPage();
    	
		PageInfo<Customer> pageInfo = new PageInfo<>(destList);

        return pageInfo;
    }
    
    @Override
    public PageInfo<CustomerFortune> selectByCustomerId(Long customerId, int pageNo, int pageSize) {
    	String orderBy = "created_at desc";
    	
    	PageHelper.startPage(pageNo, pageSize, orderBy);
         
    	Page<CustomerFortune> destList = customerFortuneMapper.selectByCustomerId(customerId);
    	
		PageInfo<CustomerFortune> pageInfo = new PageInfo<>(destList);

        return pageInfo;
    }    
}




