package com.yd.dal.service.agms.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.hiring.PractitionerHiringListRequestVO;
import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.entity.meta.MdPractitionerHiringApproveSteps;
import com.yd.dal.entity.practitioner.hiring.HiringListInfo;
import com.yd.dal.entity.user.AclUser;
import com.yd.dal.mapper.agms.AgmsHiringMapper;
import com.yd.dal.service.agms.AgmsHiringDALService;
import com.yd.dal.service.meta.MdPractitionerHiringApproveStepsDALService;
import com.yd.dal.service.practitioner.PractitionerHiringDALService;
import com.yd.dal.service.user.AclUserDALService;
import com.yd.util.CommonUtil;
import com.yd.util.page.PageInfoUtils;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xxy
 */
@Service("agmsHiringDALService")
public class AgmsHiringDALServiceImpl implements AgmsHiringDALService {

    private AgmsHiringMapper agmsHiringMapper;
    @Autowired
    private AclUserDALService aclUserDalService;
    @Autowired
    private MdPractitionerHiringApproveStepsDALService mdPractitionerHiringApproveStepsDalService;
    @Autowired
    private PractitionerHiringDALService practitionerHiringDalService;

    @Autowired
    public void setAgmsHiringMapper(AgmsHiringMapper agmsHiringMapper){
        this.agmsHiringMapper = agmsHiringMapper;
    }

    @Override
    public PractitionerHiringBasicInfo findPractitionerHiringBasicInfo(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringBasicInfo(hiringBasicInfoId);
    }

    @Override
    public PractitionerHiringMemberShip findPractitionerHiringMemberShip(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringMemberShip(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringWorkingExperience> findPractitionerHiringWorkingExperienceList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringWorkingExperienceList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringPersonalStatements> findPractitionerHiringPersonalStatementsList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringPersonalStatementsList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringContractTermsConfirms> findPractitionerHiringContractTermsConfirmsList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringContractTermsConfirmsList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringApproveRecords> findPractitionerHiringApproveRecordsList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringApproveRecordsList(hiringBasicInfoId);
    }

    @Override
    public Long findPractitionerIdByLoginId(Long loginId) {
        return agmsHiringMapper.findPractitionerIdByLoginId(loginId);
    }

    @Override
    public PageInfo<PractitionerHiringListInfo> practitionerHiringList(PractitionerHiringListRequestVO requestVO) {
        String orderBy = "hiringBasicInfoId desc";
        PageInfo<PractitionerHiringListInfo> pageInfo = requestVO.getPageInfo();
        PageHelper.startPage(pageInfo.getPageNum(),pageInfo.getPageSize(),orderBy);
        Page<PractitionerHiringListInfo> destList = agmsHiringMapper.practitionerHiringList(requestVO);
        pageInfo = new PageInfo<>(destList);
        return pageInfo;
    }

    @Override
    public PageInfo<PractitionerHiringListInfo> queryHandledList(Long loginPractitionerId, String status, PractitionerHiringListRequestVO requestVO) {

        List<PractitionerHiringListInfo> destList =
                agmsHiringMapper.queryHandledList(loginPractitionerId, status, requestVO.getBranchId(),
                        requestVO.getDeptId(),
                        requestVO.getSubsystemId(),
                        requestVO.getName());

        // list去重
        List<PractitionerHiringListInfo> uniqueList = destList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(
                // 利用 TreeSet 的排序去重构造函数来达到去重元素的目的
                // 根据hiringBasicInfoId去重
                () -> new TreeSet<>(Comparator.comparingLong(PractitionerHiringListInfo::getHiringBasicInfoId))), ArrayList::new));

        // 去重后的list分页
        PageInfo<PractitionerHiringListInfo> pageInfo = requestVO.getPageInfo();
        int pageNum = pageInfo.getPageNum();
        int pageSize = pageInfo.getPageSize();
        PageInfo<PractitionerHiringListInfo> page = PageInfoUtils.list2PageInfo(uniqueList, pageNum, pageSize);

        return page;
    }

    @Override
    public List<PractitionerHiringListInfo> queryUnhandledList(PractitionerHiringListRequestVO requestVO) {
        // 结果集
        List<PractitionerHiringListInfo> dataList = new ArrayList<>();

        AclUser user = aclUserDalService.selectByPrimaryKey(requestVO.getLoginId());
        String loginMobileNo = user.getMobileNo();
        // 查询该号码具有的审批步骤
        List<MdPractitionerHiringApproveSteps> ownSteps = mdPractitionerHiringApproveStepsDalService.findByAppointedApprovePractitioners(loginMobileNo);
        if (CollectionUtils.isEmpty(ownSteps)) {
            return dataList;
        }

        // 根据当前用户拥有的审批步骤查询每一步能够审批的数据
        String stepName;
        Integer stepSeq;
        String canAprroveGrade;
        for (MdPractitionerHiringApproveSteps step : ownSteps) {
            stepName = step.getStepName();
            stepSeq = step.getStepSeq();
            canAprroveGrade = step.getCanAprroveGrade();

            List<String> canAprroveGrades = new ArrayList<>();
            canAprroveGrades.addAll(Arrays.asList(canAprroveGrade.split(",")));

            String approveStatus = practitionerHiringDalService.getApproveStatusByStepSeq(stepSeq);
            List<PractitionerHiringListInfo> resultList =
                    agmsHiringMapper.queryUnhandledList(approveStatus, canAprroveGrades,
                            requestVO.getBranchId(),
                            requestVO.getDeptId(),
                            requestVO.getSubsystemId(),
                            requestVO.getName()
                    );
            if (CollectionUtils.isNotEmpty(resultList)) {
                dataList.addAll(resultList);
            }

            if ("公司老板".equals(stepName)) {
                List<PractitionerHiringListInfo> s2List = agmsHiringMapper.queryS2List();
                dataList.addAll(s2List);
            }

        }
        return dataList;
    }
}
