package com.yd.api.agms.service.impl;

import com.yd.api.agms.service.AgmsDashboardService;
import com.yd.api.agms.vo.dashboard.StatisticsPEPByBranchRequestVO;
import com.yd.api.agms.vo.dashboard.StatisticsPEPByBranchResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.agms.dashboard.StatisticsPEPInfo;
import com.yd.dal.service.agms.AgmsDashboardDALService;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("agmsDashboardService")
public class AgmsDashboardServiceImpl implements AgmsDashboardService {

    @Autowired
    private AgmsDashboardDALService agmsDashboardDALService;

    @Override
    public StatisticsPEPByBranchResponseVO statisticsPEPByBranch(StatisticsPEPByBranchRequestVO requestVO) {
        //AGMS -- Dashboard查询  寿险整体运营->PEP活动管理(根据公司)
        StatisticsPEPByBranchResponseVO responseVO = new StatisticsPEPByBranchResponseVO();
        List<StatisticsPEPInfo> statisticsPEPInfos = agmsDashboardDALService.statisticsPEPByBranch();
        responseVO.setStatisticsPEPInfos(statisticsPEPInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
