package com.yd.api.practitioner;

import java.io.*;
import java.util.*;

import com.libs.pdf.freemarker.HtmlGenerator;
import com.libs.pdf.freemarker.PdfGenerator;
import com.yd.api.practitioner.vo.CommissionItems;
import com.yd.api.practitioner.vo.Commission;

public class PractitionerSalaryPDFTest {

    public static void main(String[] args) {
        try
        {
            //html模板文件
            String tempFilfe = "practitionerSalaryTemplate.html";
            //pdf输出文件
            String outputFile = "D:/sample.pdf";
            //模板上的变量定义
            Map<String, Object> variables = new HashMap<String, Object>(3);

            //佣金项目列表变量
            List<CommissionItems> comList = new ArrayList<CommissionItems>();
            //列表1：☆S01 首年度销售佣金
            CommissionItems tomS01 = new CommissionItems();
            tomS01.setName("☆S01 首年度销售佣金");
            //列表1中的条目明细
            List<Commission> tomItems1 = new ArrayList<Commission>();
            Commission tomItem1 = new Commission();
            tomItem1.setInsurer("泰康人寿");
            tomItem1.setCommission("56.78");
            tomItem1.setEffectiveDate("2021.2.1");
            tomItem1.setFyc("45.00");
            tomItem1.setGradeRate("86");
            tomItem1.setInsured("姑苏蓝氏");
            tomItem1.setNote("首保");
            tomItem1.setPolicyNo("TKSH000012345");
            tomItem1.setPremium("125.90");
            tomItem1.setProductCode("PTK789001");
            tomItem1.setSubSystem("王子");
            tomItem1.setYearMonth("202102");

            tomItems1.add(tomItem1);

            tomS01.setItems(tomItems1);
            comList.add(tomS01);
            //列表2：☆S03 首年度辅导奖金
            CommissionItems tomS03 = new CommissionItems();
            tomS03.setName("☆S03 首年度辅导奖金");
            //列表2中的条目明细
            List<Commission> tomItems3 = new ArrayList<Commission>();
            Commission tomItem3 = new Commission();
            tomItem3.setInsurer("泰康人寿");
            tomItem3.setCommission("3451.00");
            tomItem3.setEffectiveDate("2021.1.1");
            tomItem3.setFyc("5433.00");
            tomItem3.setGradeRate("53%");
            tomItem3.setInsured("王一博");
            tomItem3.setNote("首保");
            tomItem3.setPolicyNo("TKSC00012123100K");
            tomItem3.setPremium("6756.00");
            tomItem3.setProductCode("PTK000211");
            tomItem3.setSubSystem("王子");
            tomItem3.setYearMonth("202101");
            tomItems3.add(tomItem3);
            //列表2中的条目明细
            Commission tomItem32 = new Commission();
            tomItem32.setInsurer("泰康人寿");
            tomItem32.setCommission("879.33");
            tomItem32.setEffectiveDate("2021.2.1");
            tomItem32.setFyc("561.30");
            tomItem32.setGradeRate("56");
            tomItem32.setInsured("李现");
            tomItem32.setNote("首保");
            tomItem32.setPolicyNo("TKJS000222");
            tomItem32.setPremium("3211.90");
            tomItem32.setProductCode("PTK3333");
            tomItem32.setSubSystem("王子");
            tomItem32.setYearMonth("202102");
            tomItems3.add(tomItem32);

            tomS03.setItems(tomItems3);
            comList.add(tomS03);

            //列表3:☆S14 特别管理奖金
            CommissionItems tomSS14 = new CommissionItems();
            tomSS14.setName("☆S14 特别管理奖金");
            //列表3中的条目明细
            List<Commission> tomItems14 = new ArrayList<Commission>();
            Commission tomItem14 = new Commission();
            tomItem14.setInsurer("泰康人寿");
            tomItem14.setCommission("3423.45");
            tomItem14.setEffectiveDate("2021.3.1");
            tomItem14.setFyc("5335.00");
            tomItem14.setGradeRate("56");
            tomItem14.setInsured("肖战");
            tomItem14.setNote("续保");
            tomItem14.setPolicyNo("TKSH000020210301000176");
            tomItem14.setPremium("8899.00");
            tomItem14.setProductCode("PTK03214");
            tomItem14.setSubSystem("王子");
            tomItem14.setYearMonth("202103");
            tomItems14.add(tomItem14);

            tomSS14.setItems(tomItems14);
            comList.add(tomSS14);

            //html模板中的其他单值变量
            variables.put("commissionYearMonth", "202103");
            variables.put("commissionDate", "20210310");
            variables.put("branch", "上海总部");
            variables.put("practitionerNameCode", "YDSH00338");
            variables.put("bankAccount", "6222010101012234589");
            variables.put("subSystem", "王子");
            variables.put("grade", "S2 企业合伙人");
            variables.put("fyp", "5678.90");
            variables.put("fap", "3457.87");
            variables.put("other", "90.00");

            variables.put("otherAddPlus", "0.00");
            variables.put("tax", "0.00");
            variables.put("totalCommission", "7658.89");
            variables.put("otherSummary", "0.00");
            variables.put("supplementTax", "0.00");
            variables.put("otherTaxSummary", "0.00");

            variables.put("currentActualSalary", "7658.89");
            variables.put("currentTaxBeforeSalary", "7658.89");
            variables.put("currentYearTaxBeforeSalary", "7658.89");
            variables.put("preTaxOffRate", "78");

            variables.put("currentYearTaxSummary", "7658.89");
            variables.put("currentTax", "0.00");
            variables.put("currentMonthFYC", "7658.89");
            variables.put("currentYearFYC", "7658.89");
            variables.put("currentMonthRYC", "7658.89");

            //html模板中的列表变量
            variables.put("comList", comList);

            String htmlStr = HtmlGenerator.generate(tempFilfe, variables);

            OutputStream out = new FileOutputStream(outputFile);
            PdfGenerator.generatePlus(htmlStr, out);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

