package com.yd.dal.service.agms;

import com.yd.api.agms.vo.dashboard.StatisticsPractitionerInfo;
import com.yd.api.agms.vo.dashboard.StatisticsSalesInfo;
import com.yd.dal.entity.agms.dashboard.StatisticsOpportunityInfo;
import com.yd.dal.entity.agms.dashboard.StatisticsPEPInfo;
import com.yd.dal.entity.practitioner.PersonalOffLineFYC;
import com.yd.rmi.n22.salary.pojo.Achieve;

import java.util.List;
import java.util.Map;

public interface AgmsDashboardDALService {
    List<StatisticsPEPInfo> statisticsPEP(String type,Long dropOptionId);

    List<StatisticsOpportunityInfo> statisticsOpportunity(String type,String time, Long id);

    List<StatisticsSalesInfo> statisticsSalesYD(String category, String type, String time);

    List<StatisticsPractitionerInfo> statisticsPractitioner(String type, String time);

    List<StatisticsSalesInfo> statisticsSalesEG(String type, String time);

    List<PersonalOffLineFYC> offLineFYC(List<String> mobileNoList);

    void getUnitPremium(List<StatisticsSalesInfo> statisticsSalesInfos);

    /**
     *
     * @param time 1-month,2-year,3-quarter
     * @param isPersonal 0-查询当前经纪人的个人数据，1-查询所有经纪人的数据
     * @param loginName isPersonal为0时必填
     * @return
     */
    List<Achieve> queryN22FYC(Integer time, Integer isPersonal, String loginName);

    List<Map<String, Object>> queryTeamAllMap();
}
