package com.yd.dal.service.agms;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.hiring.PractitionerHiringListRequestVO;
import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.entity.customer.AclPractitionerHiringMembership;

import java.util.List;

/**
 * @author xxy
 */
public interface AgmsHiringDALService {
    /**
     * 经纪人审批基本信息
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    PractitionerHiringBasicInfo findPractitionerHiringBasicInfo(Long hiringBasicInfoId);
    /**
     * 审批经纪人关系
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    PractitionerHiringMemberShip findPractitionerHiringMemberShip(Long hiringBasicInfoId);
    /**
     * 审批经纪人工作经历
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringWorkingExperience> findPractitionerHiringWorkingExperienceList(Long hiringBasicInfoId);
    /**
     * 经纪人申请名目
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringPersonalStatements> findPractitionerHiringPersonalStatementsList(Long hiringBasicInfoId);
    /**
     * 经纪人合同条款是否同意
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringContractTermsConfirms> findPractitionerHiringContractTermsConfirmsList(Long hiringBasicInfoId);
    /**
     * 已审批结果
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<PractitionerHiringApproveRecords> findPractitionerHiringApproveRecordsList(Long hiringBasicInfoId);

    /**
     * 通过loginId查询对应的经纪人id
     * @param loginId agms登入者id
     * @return 经纪人id
     */
    Long findPractitionerIdByLoginId(Long loginId);

    /**
     * 经纪人报聘列表查询
     * @param requestVO
     * @return
     */
    PageInfo<PractitionerHiringListInfo> practitionerHiringList(PractitionerHiringListRequestVO requestVO);

    PageInfo<PractitionerHiringListInfo> queryHandledList(Long practitionerId, String status,
                                                          PractitionerHiringListRequestVO requestVO);

    List<PractitionerHiringListInfo> queryUnhandledList(PractitionerHiringListRequestVO requestVO);

    AclPractitionerHiringMembership queryHiringMemberShip(Long hiringBasicInfoId);
}
