package com.yd.dal.service.commission;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.yd.dal.entity.commission.Commission;
import com.yd.dal.mapper.commission.CommissionMapper;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;

import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.List;

/**
 * @Transactional class level transaction管理
 * @author Simon
 * @version 1.0
 */
@Service("commissionServiceDAImpl")
@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
public class CommissionServiceDAImpl implements CommissionServiceDA {

    private static final Logger LOG = Logger.getLogger(CommissionServiceDAImpl.class);

    @Resource
    private CommissionMapper commissionMapper;

    /*
     * 按照手机号从AGMS DB中查询佣金
     * 通过标签指定数据源：dataSourceKey = DataSourceKey.DB_MASTER
     * 不指定@TargetDataSource，缺省的就是DB_MASTER主库
     * 
     * @Transactional method level transaction管理
     * (non-Javadoc)
     * @see com.yd.dataccess.service.commission.CommissionServiceDA#queryCommissionByLogin(java.lang.String)
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)    
    public List<Commission> queryCommissionByLogin(String login){
    	List<Commission> destList = new ArrayList<Commission>();

        destList = commissionMapper.queryCommissionByLogin(login);

        return destList;
    }
}
