package com.yd.dal.mapper.agms;

import com.github.pagehelper.Page;
import com.yd.api.agms.vo.practitioner.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author xxy
 */
public interface AgmsPractitionerMapper {
    /**
     *
     * @param mdDropOptionIds 文章类型
     * @param isActive 是否启用
     * @return
     */
    Page<PractitionerFileSharing> practitionerFileSharingList(@Param("id")Long id,
                                                              @Param("practitionerId") Long practitionerId,
                                                              @Param("shareCode") String shareCode,
                                                              @Param("mdDropOptionIds") Long[] mdDropOptionIds ,
                                                              @Param("isActive") Integer isActive);

    SharePractitionerInfo findSharePractitioner(String shareCode);

    List<PractitionerScheduleInfo> practitionerSchedule(PractitionerScheduleRequestVO requestVO);

    List<PractitionerLeadsGoalsInfo> practitionerLeadsGoals(PractitionerLeadsGoalsRequestVO requestVO);

    List<Map<String, Object>> practitionerScheduleExport(PractitionerScheduleRequestVO requestVO);

    List<Map<String, Object>> practitionerLeadsGoalsExport(PractitionerLeadsGoalsRequestVO requestVO);

    List<PractitionerActivityInfo> practitionerActivity(PractitionerActivityRequestVO requestVO);

    List<Map<String, Object>> practitionerActivityExport(PractitionerActivityRequestVO requestVO);
}

