package com.yd.dal.service.customer;

import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.customer.practitioner.AclPractitionerInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerRankInfo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclPractitionerDALService")
public interface AclPractitionerDALService {
    /**
     * 通过customerId 和is_active 获取用户
     * @param customerId
     * @param i
     * @return
     */
    AclPractitioner findByCustomerIdIsActive(Long customerId, int i);

    /**
     * 线下--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOffline(String mobileNo);
    /**
     * 线上--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOnline(String mobileNo);

    /**
     * 线下--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time);

    /**
     * 线上--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time,Long practitionerTypeId);

    /**
     * 线上--按照时间进行查询特殊人员的排名统计信息
     * @param mobileSpecials
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(List<String> mobileSpecials,Integer time);

    /**
     * 经纪人基本信息查询
     * @param mobileNo
     * @return
     */
    PractitionerInfo findPractitionerInfoByLogin(String mobileNo);

    /**
     * 通过经纪人id查找经纪人
     * @param practitionerId
     * @return
     */
    AclPractitioner findPractitionerById(Long practitionerId);

    /**
     * 经纪人查询自己的商机
     * @param practitionerId
     * @return
     */
    List<OwnOpportunityInfo> ownOpportunityQuery(Long practitionerId);
    void updatePractitioner(AclPractitioner practitioner);
}
