package com.yd.dal.service.practitioner.impl;

import com.google.common.base.Strings;
import com.yd.dal.entity.practitioner.AclPractitionerInfo;
import com.yd.dal.entity.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.practitioner.PractitionerInfo;
import com.yd.dal.entity.practitioner.PractitionerRankInfo;
import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;
import com.yd.dal.mapper.practitioner.AclPractitionerMapper;
import com.yd.dal.mapper.practitioner.PractitionerMapper;
import com.yd.dal.service.customer.impl.CustomerDALServiceImpl;
import com.yd.dal.service.practitioner.PractitionerDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("practitionerServiceDAL")
public class PractitionerDALServiceImpl implements PractitionerDALService {
    private static final Logger LOG = Logger.getLogger(CustomerDALServiceImpl.class);
    @Resource
    private PractitionerMapper practitionerMapper;
    @Resource
    private AclPractitionerMapper aclPractitionerMapper;
    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public PractitionerBasicInfo getPractitionerBasicInfoForOffline(String mobileNo) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            return practitionerMapper.getPractitionerInfoByMobileNoForOffline(mobileNo);
        }else{
            LOG.error("mobileNo is null！");
        }
        return null;
    }

    @Override
    public PractitionerBasicInfo getPractitionerBasicInfoForOnline(String mobileNo) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            return practitionerMapper.getPractitionerInfoByMobileNoForOnline(mobileNo);
        }else{
            LOG.error("mobileNo is null！");
        }
        return null;
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time) {
        return practitionerMapper.getPractitionerRankInfoForOffline(time);
    }

    @Override
    public List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time,Long practitionerTypeId) {
        return practitionerMapper.getPractitionerRankInfoForOnline(time,practitionerTypeId);
    }

    @Override
    public List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(List<String> mobileSpecials,Integer time) {
        return practitionerMapper.getPractitionerRankInfoForSpecials(mobileSpecials,time);
    }

    @Override
    public PractitionerInfo findPractitionerInfoByLogin(String mobileNo) {
        return practitionerMapper.findPractitionerInfoByLogin(mobileNo);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)
    public AclPractitionerInfo findPractitionerById(Long practitionerId) {
        return aclPractitionerMapper.selectByPrimaryKey(practitionerId);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_MASTER)
    public void updatePractitioner(AclPractitionerInfo practitioner) {
        aclPractitionerMapper.updateByPrimaryKeySelective(practitioner);
    }

    @Override
    public List<OwnOpportunityInfo> ownOpportunityQuery(Long practitionerId) {
        return practitionerMapper.ownOpportunityQuery(practitionerId);
    }
}
