package com.yd.api.practitioner;


import com.yd.api.practitioner.service.PractitionerHiringService;
import com.yd.api.practitioner.vo.hiring.*;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经纪人报聘
 */
@RestController
@RequestMapping("/practitionerHiring")
public class PractitionerHiringController {
	
	@Autowired
	private PractitionerHiringService practitionerHiringService;

	/**
	 * 保存报聘经纪人组织关系
	 *
	 */
	@RequestMapping("/saveMembership")
	public Object saveMembership(@RequestBody SaveMembershipRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveMembershipResponseVO responseVO = practitionerHiringService.saveMembership(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 根据BasicInfoId查询报聘经纪人组织关系
	 *
	 */
	@RequestMapping("/queryMembershipByHiringBasicInfoId")
	public Object queryMembership(@RequestBody QueryMembershipRequestVO requestVO){
		JsonResult result = new JsonResult();
		QueryMembershipResponseVO responseVO = practitionerHiringService.queryMembership(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人基本信息
	 *
	 */
	@RequestMapping("/saveBasicInfo")
	public Object saveBasicInfo(@RequestBody SaveBasicInfoRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveBasicInfoResponseVO responseVO = practitionerHiringService.saveBasicInfo(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人工作经历
	 *
	 */
	@RequestMapping("/saveWorkingExperience")
	public Object saveWorkingExperience(@RequestBody SaveWorkingExperienceRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveWorkingExperienceResponseVO responseVO = practitionerHiringService.saveWorkingExperience(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人个人照片
	 *
	 */
	@RequestMapping("/savePersonPicture")
	public Object savePersonPicture(@RequestBody SavePersonPictureRequestVO requestVO){
		JsonResult result = new JsonResult();
		SavePersonPictureResponseVO responseVO = practitionerHiringService.savePersonPicture(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人身份证正反面图片
	 *
	 */
	@RequestMapping("/saveIDPicture")
	public Object saveIDPicture(@RequestBody SaveIDPictureRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveIDPictureResponseVO responseVO = practitionerHiringService.saveIDPicture(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人最高学历
	 *
	 */
	@RequestMapping("/saveLastGraduateGrade")
	public Object saveLastGraduateGrade(@RequestBody SaveLastGraduateGradeRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveLastGraduateGradeResponseVO responseVO = practitionerHiringService.saveLastGraduateGrade(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人个人声明
	 *
	 */
	@RequestMapping("/savePersonalStatements")
	public Object savePersonalStatements(@RequestBody SavePersonalStatementsRequestVO requestVO){
		JsonResult result = new JsonResult();
		SavePersonalStatementsResponseVO responseVO = practitionerHiringService.savePersonalStatements(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人合同文档确认
	 *
	 */
	@RequestMapping("/saveContractTermsConfirms")
	public Object saveContractTermsConfirms(@RequestBody SaveContractTermsConfirmsRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveContractTermsConfirmsResponseVO responseVO = practitionerHiringService.saveContractTermsConfirms(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 经纪人审批列表查询
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/listQuery")
	public Object listQuery(@RequestBody HiringListQueryRequestVO requestVO){
		JsonResult result = new JsonResult();
		HiringListQueryResponseVO responseVO = practitionerHiringService.listQuery(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 经纪人审批详情查询
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/detailQuery")
	public Object detailQuery(@RequestBody HiringDetailQueryRequestVO requestVO){
		JsonResult result = new JsonResult();
		HiringDetailQueryResponseVO responseVO = practitionerHiringService.detailQuery(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * ydLife经纪人审批
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/hiringApprove")
	public Object hiringApprove(@RequestBody HiringApproveRequestVO requestVO){
		JsonResult result = new JsonResult();
		HiringApproveResponseVO responseVO = practitionerHiringService.hiringApprove(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}
}