package com.yd.dal.mapper.customer;

import com.yd.api.practitioner.vo.payscale.PayScaleInfo;
import com.yd.api.practitioner.vo.subordinate.TeamMemberDetail;
import com.yd.api.practitioner.vo.unionSales.UnionSalesPractitionerInfo;
import com.yd.dal.entity.customer.AclPractitioner;
import java.util.List;
import com.yd.dal.entity.customer.practitioner.PractitionerBasicInfo;import com.yd.dal.entity.customer.practitioner.PractitionerInfo;import com.yd.dal.entity.customer.practitioner.PractitionerRankInfo;import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;import com.yd.dal.entity.practitioner.opportunity.PlayerSalesActivityInfo;import com.yd.dal.entity.practitioner.payscale.PayScaleBasicInfo;import org.apache.ibatis.annotations.Param;

public interface AclPractitionerMapper {
    int deleteByPrimaryKey(Long id);

    int insert(AclPractitioner record);

    int insertSelective(AclPractitioner record);

    AclPractitioner selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AclPractitioner record);

    int updateByPrimaryKey(AclPractitioner record);

    int updateBatch(List<AclPractitioner> list);

    int updateBatchSelective(List<AclPractitioner> list);

    int batchInsert(@Param("list") List<AclPractitioner> list);

    PractitionerBasicInfo getPractitionerInfoByMobileNoForOffline(String mobileNo);

    List<PractitionerRankInfo> getPractitionerRankInfoForOffline(@Param("time") Integer time);

    PractitionerBasicInfo getPractitionerInfoByMobileNoForOnline(String mobileNo);

    List<PractitionerRankInfo> getPractitionerRankInfoForOnline(@Param("time") Integer time, @Param("practitionerTypeId") Long practitionerTypeId,@Param("platform") Integer platform,@Param("type") Integer type,@Param("mobileSpecials") List<String> mobileSpecials);

    /**
     * 查询经纪人的个人统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfo(@Param("time") Integer time, @Param("practitionerTypeId") Long practitionerTypeId,@Param("platform") Integer platform,@Param("type") Integer type,@Param("practitionerId") Integer practitionerId);

    List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(@Param("mobileSpecials") List<String> mobileSpecials, @Param("time") Integer time,  @Param("platform") Integer platform);

    PractitionerInfo findPractitionerInfoByLogin(@Param("mobileNo") String mobileNo);

    AclPractitioner findByCustomerIdIsActive(@Param("customerId") Long customerId, @Param("isActive") int isActive);

    List<OwnOpportunityInfo> ownOpportunityQuery(@Param("practitionerId") Long practitionerId);

    List<AclPractitioner> findByIds(@Param("practitionerIdList") List<Long> practitionerIdList);

    List<AclPractitioner> findForSubordinateIdByPractitionerId(Long practitionerId);

    List<PlayerSalesActivityInfo> playerSalesActivityQuery(@Param("practitionerId") Long practitionerId, @Param("optionsId") Long optionsId);

    List<AclPractitioner> findBySubordinateSystemId(@Param("subordinateSystemId") Long subordinateSystemId,@Param("systemType") String systemType);

    String findMobileNoByPractitionerId(@Param("practitionerId") Long practitionerId);

    PractitionerBasicInfo findByMobileNoE(@Param("mobileNo") String mobileNo);

    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdEG(@Param("practitionerIdEG") String practitionerIdEG, @Param("time") Integer time);

    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdYD(@Param("practitionerId") Long practitionerId, @Param("time") Integer time, @Param("platform") Integer platform);

    List<PayScaleInfo> findPayScaleByPractitionerEG(@Param("practitionerIdEG") String practitionerIdEG);

    PayScaleBasicInfo findFilePathByMonShId(@Param("monShId") Integer monShId);

    PractitionerBasicInfo findByIdEG(@Param("practitionerIdEG") String practitionerIdEG);

    AclPractitioner findPractitionerByLeadsAssignedId(Long leadsAssignedId);

    List<AclPractitioner> findAll();

    int isTeamLeader(Long practitionerId);

    List<Long> queryTeamAllPractitionerId(@Param("practitionerId")Long practitionerId,@Param("isActive")Integer isActive);

    List<Long> queryMentoredByPractitionerId(Long practitionerId);

    PractitionerInfo findPractitionerInfoByPractitionerId(Long practitionerId);

    AclPractitioner selectByMobileNo(String mobileNo);

    List<TeamMemberDetail> queryTeamMemberDetailList(List<Long> practitionerIdList);

    List<String> findLeaveOfficeByPractitionerId(Long practitionerId);

    List<AclPractitioner> queryAllLifePractitioner();

    List<PractitionerInfo> findPractitionerInfoByPractitionerCode(List<String> paramList);

    List<PractitionerInfo> findPractitionerInfoByNameList(List<String> nameList);

    List<PractitionerInfo> findPractitionerInfoByMobileList(List<String> mobileList);

    List<PayScaleInfo> queryEGHistorySalaryPDFByPractitionerId(Long practitionerId);

    public List<TeamMemberDetail> queryTeamMemberDetailRaiseList(List<Long> practitionerIdList);
    
    public List<AclPractitioner> findPractitionerByRaise(Long practitionerId);
    
    /**
     * 通过联合销售ID查询联合销售经纪人信息列表
     * @param unionSalesId 联合销售ID
     * @param unionSalesPractitionerId 联合销售经纪人ID
     * @return List<UnionSalesPractitionerInfo> 业务对象列表
     * @author Yan Wenyang
     */
    List<UnionSalesPractitionerInfo> findUnionSalesPractitionerByUnionSalesId(@Param("unionSalesId")Long unionSalesId, @Param("unionSalesPractitionerId")Long unionSalesPractitionerId);
    
    /**
     * 更新联合销售经纪人信息
     * @param unionSalesPractitionerId 联合销售经纪人ID
     * @param ossPathImg 签署图片
     * @param singX 签署位置X
     * @param singY 签署位置Y
     * @param signStatus 签署状态
     * @return void
     * @author Yan Wenyang
     */
	void updateUnionSalesPractitioner(@Param("unionSalesPractitionerId")Long unionSalesPractitionerId, @Param("ossPathImg")String ossPathImg, @Param("singX")int singX, @Param("singY")int singY, @Param("signStatus")String signStatus);
	
	/**
	 * 更新联合销售信息
	 * @param unionSalesId 联合销售ID
	 * @param ossPath 签署文件
	 * @param signStatus 签署状态
     * @return void
     * @author Yan Wenyang
	 */
	void updateUnionSales(@Param("unionSalesId")Long unionSalesId, @Param("ossPath")String ossPath, @Param("signStatus")String signStatus);
	
}
