package com.yd.dal.service.agms;

import com.yd.dal.entity.agms.fortune.*;
import com.yd.dal.entity.agms.fortune.CommissionPayoutStatus;
import com.yd.dal.entity.agms.fortune.CommissionPayoutStatusQueryInfo;
import com.yd.dal.entity.agms.fortune.CustomerFortuneStatisticalInfo;
import com.yd.dal.entity.customer.AclCustomerFortune;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xxy
 */
public interface AgmsFortuneDALService {
    /**
     * 通过customerid查询财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     * @param customerIds customerIds
     * @return 财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     */
    Map<Long,CustomerFortuneStatisticalInfo> findFortuneStatisticalByCustomers(Set<Long> customerIds);

    /**
     * 发佣检核列表
     * @param requestVO 过滤条件
     * @return 返回结果
     */
    List<CommissionPayoutStatus> commissionPayoutStatusQuery(CommissionPayoutStatusQueryInfo requestVO);

    List<AclCustomerFortune> queryLifeFortuneListByOrderIds(List<Long> orderIds);

    List<AclCustomerFortune> findByOrderId(Long orderId);

    /**
     * 通过customerId和payId查询fortune记录
     * @param payId payId
     * @return FortunePayToOrderInfo
     */
    List<FortunePayToOrderInfo> fortunePayToOrder(Long[] payId);

    /**
     * 支付列表插叙
     * @param info info
     * @return WithdrawLabelInfo
     */
    List<WithdrawLabelInfo> transformForWithdrawLabel(WithdrawQueryInfo info);

}
