package com.yd.api.agms.service.impl;

import com.yd.api.agms.service.AgmsHiringService;
import com.yd.api.agms.vo.hiring.PractitionerHiringDetailRequestVO;
import com.yd.api.agms.vo.hiring.PractitionerHiringDetailResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.service.agms.AgmsHiringDALService;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxy
 */
@Service("agmsHiringService")
public class AgmsHiringServiceImpl implements AgmsHiringService {

    private AgmsHiringDALService agmsHiringDalService;

    @Autowired
    public void setAgmsHiringDalService(AgmsHiringDALService agmsHiringDalService){
        this.agmsHiringDalService = agmsHiringDalService;
    }

    @Override
    public PractitionerHiringDetailResponseVO practitionerHiringDetail(PractitionerHiringDetailRequestVO requestVO) {
        PractitionerHiringDetailResponseVO responseVO = new PractitionerHiringDetailResponseVO();

        Long hiringBasicInfoId = requestVO.getHiringBasicInfoId();
        //经纪人审批基本信息
        PractitionerHiringBasicInfo practitionerHiringBasicInfo = agmsHiringDalService.findPractitionerHiringBasicInfo(hiringBasicInfoId);
        //审批经纪人关系
        PractitionerHiringMemberShip practitionerHiringMemberShip = agmsHiringDalService.findPractitionerHiringMemberShip(hiringBasicInfoId);
        //审批经纪人工作经历
        List<PractitionerHiringWorkingExperience> practitionerHiringWorkingExperienceList = agmsHiringDalService.findPractitionerHiringWorkingExperienceList(hiringBasicInfoId);;
        //经纪人申请名目
        List<PractitionerHiringPersonalStatements> practitionerHiringPersonalStatementsList = agmsHiringDalService.findPractitionerHiringPersonalStatementsList(hiringBasicInfoId);;
        //经纪人合同条款是否同意
        List<PractitionerHiringContractTermsConfirms> practitionerHiringContractTermsConfirmsList = agmsHiringDalService.findPractitionerHiringContractTermsConfirmsList(hiringBasicInfoId);;
        //已审批结果
        List<PractitionerHiringApproveRecords> practitionerHiringApproveRecordsList = agmsHiringDalService.findPractitionerHiringApproveRecordsList(hiringBasicInfoId);;

        responseVO.setHiringBasicInfoId(hiringBasicInfoId);
        responseVO.setPractitionerHiringBasicInfo(practitionerHiringBasicInfo);
        responseVO.setPractitionerHiringMemberShip(practitionerHiringMemberShip);
        responseVO.setPractitionerHiringWorkingExperienceList(practitionerHiringWorkingExperienceList);
        responseVO.setPractitionerHiringPersonalStatementsList(practitionerHiringPersonalStatementsList);
        responseVO.setPractitionerHiringContractTermsConfirmsList(practitionerHiringContractTermsConfirmsList);
        responseVO.setPractitionerHiringApproveRecordsList(practitionerHiringApproveRecordsList);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
