package com.yd.api.practitioner;

import com.yd.api.practitioner.service.PractitionerHiringContractService;
import com.yd.api.practitioner.service.PractitionerHiringService;
import com.yd.api.practitioner.vo.hiring.*;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经纪人报聘
 */
@RestController
@RequestMapping("/practitionerHiring")
public class PractitionerHiringController {
	
	@Autowired
	private PractitionerHiringService practitionerHiringService;


	/**
	 * 保存报聘经纪人组织关系
	 *
	 */
	@RequestMapping("/saveMembership")
	public Object saveMembership(@RequestBody SaveMembershipRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveMembershipResponseVO responseVO = practitionerHiringService.saveMembership(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 根据BasicInfoId查询报聘经纪人组织关系
	 *
	 */
	@RequestMapping("/queryMembershipByHiringBasicInfoId")
	public Object queryMembership(@RequestBody HiringBasicInfoIdRequestVO requestVO){
		JsonResult result = new JsonResult();
		QueryMembershipResponseVO responseVO = practitionerHiringService.queryMembership(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人基本信息
	 *
	 */
	@RequestMapping("/saveBasicInfo")
	public Object saveBasicInfo(@RequestBody SaveBasicInfoRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.saveBasicInfo(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人工作经历
	 *
	 */
	@RequestMapping("/saveWorkingExperience")
	public Object saveWorkingExperience(@RequestBody SaveWorkingExperienceRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.saveWorkingExperience(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人个人照片
	 *
	 */
	@RequestMapping("/savePersonPicture")
	public Object savePersonPicture(@RequestBody SavePersonPictureRequestVO requestVO){
		JsonResult result = new JsonResult();
		SavePersonPictureResponseVO responseVO = practitionerHiringService.savePersonPicture(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人薪资单图片
	 *
	 */
	@RequestMapping("/savePayrollPicture")
	public Object savePayrollPicture(@RequestBody SavePayRollPictureRequestVO requestVO){
		JsonResult result = new JsonResult();
		SavePayrollPictureResponseVO responseVO = practitionerHiringService.savePayrollPicture(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人身份证正反面图片
	 *
	 */
	@RequestMapping("/saveIDPicture")
	public Object saveIDPicture(@RequestBody SaveIDPictureRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveIDPictureResponseVO responseVO = practitionerHiringService.saveIDPicture(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人最高学历
	 *
	 */
	@RequestMapping("/saveLastGraduateGrade")
	public Object saveLastGraduateGrade(@RequestBody SaveLastGraduateGradeRequestVO requestVO){
		JsonResult result = new JsonResult();
		SaveLastGraduateGradeResponseVO responseVO = practitionerHiringService.saveLastGraduateGrade(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人个人声明
	 *
	 */
	@RequestMapping("/savePersonalStatements")
	public Object savePersonalStatements(@RequestBody SavePersonalStatementsRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.savePersonalStatements(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人合同文档确认
	 *
	 */
	@RequestMapping("/saveContractTermsConfirms")
	public Object saveContractTermsConfirms(@RequestBody SaveContractTermsConfirmsRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.saveContractTermsConfirms(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人银行账户
	 *
	 */
	@RequestMapping("/saveBankAccount")
	public Object saveBankAccount(@RequestBody SaveBankAccountRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.saveBankAccount(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 查询报聘经纪人的合同条款列表
	 *
	 */
	@RequestMapping("/queryContractTerms")
	public Object queryContractTerms(){
		JsonResult result = new JsonResult();
		QueryContractTermsResponseVO responseVO = practitionerHiringService.queryContractTerms();
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 查询报聘经纪人的全部报聘信息
	 *
	 */
	@RequestMapping("/queryWholeInfo")
	public Object queryWholeInfo(@RequestBody HiringBasicInfoIdRequestVO requestVO){
		JsonResult result = new JsonResult();
		QueryWholeInfoResponseVO responseVO = practitionerHiringService.queryWholeInfo(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 全部报聘信息已提交，将状态改为已填完
	 *
	 */
	@RequestMapping("/hiringSubmit")
	public Object hiringSubmit(@RequestBody HiringBasicInfoIdRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.hiringSubmit(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 保存报聘经纪人电子签名
	 *
	 */
	@RequestMapping("/saveDigitalSignatures")
	public Object saveDigitalSignatures(@RequestBody SaveDigitalSignaturesRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = practitionerHiringService.saveDigitalSignatures(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 经纪人审批列表查询
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/listQuery")
	public Object listQuery(@RequestBody HiringListQueryRequestVO requestVO){
		JsonResult result = new JsonResult();
		HiringListQueryResponseVO responseVO = practitionerHiringService.listQuery(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 经纪人审批详情查询
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/detailQuery")
	public Object detailQuery(@RequestBody HiringDetailQueryRequestVO requestVO){
		JsonResult result = new JsonResult();
		HiringDetailQueryResponseVO responseVO = practitionerHiringService.detailQuery(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * ydLife经纪人审批
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/generatePDF")
	public Object generatePDF(@RequestBody GeneratePDFRequestVO requestVO){
		JsonResult result = new JsonResult();
		GeneratePDFResponseVO responseVO = practitionerHiringService.generatePDF(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 报聘成功后查看经纪人信息
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping("/queryPractitionerInfo")
	public Object queryPractitionerInfo(@RequestBody QueryPractitionerInfoRequestVO requestVO){
		JsonResult result = new JsonResult();
		QueryPractitionerInfoResponseVO responseVO = practitionerHiringService.queryPractitionerInfo(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}
}