package com.yd.dal.service.marketing.Impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.dal.entity.marketing.MktAnnouncement;
import com.yd.dal.mapper.marketing.MktAnnouncementMapper;
import com.yd.dal.service.marketing.MktAnnouncementDALService;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service("mktAnnouncementDALService")
public class MktAnnouncementDALServiceImpl implements MktAnnouncementDALService {
    @Resource
    private MktAnnouncementMapper mktAnnouncementMapper;

    @Override
    public MktAnnouncement findById(Long id) {
        return mktAnnouncementMapper.selectByPrimaryKey(id);
    }

    @Override
	@SuppressWarnings("unchecked")
    public List<MktAnnouncement> findByType(Long announcementType) {
        MktAnnouncement info = new MktAnnouncement();
        info.setAnnouncementType(announcementType);
        info.setIsActive(1);
        PageHelper.orderBy("seq asc , created_at desc");
        Page<MktAnnouncement> mktAnnouncementPageInfo = mktAnnouncementMapper.selectByObj(info);
        PageInfo<MktAnnouncement> pageInfo = new PageInfo<>(mktAnnouncementPageInfo);
        List<MktAnnouncement> list = pageInfo.getList();
        BeanPropertyValueEqualsPredicate predicateClause = new BeanPropertyValueEqualsPredicate("seq", 0);
        List<MktAnnouncement> listTop = (List<MktAnnouncement>) CollectionUtils.select(list, predicateClause);
        if(listTop != null && listTop.size() > 0){
        	list.removeAll(listTop);
        	listTop.addAll(list);
        	return listTop;
        }
        return list;
    }

    @Override
    public List<MktAnnouncement> findByIsActiveAndAnnouncementAtBefore(int isActive, Date date) {
    	List<MktAnnouncement> listTop = mktAnnouncementMapper.findByIsActiveAndAnnouncementAtBeforeTop(isActive,date);
    	List<MktAnnouncement> list = mktAnnouncementMapper.findByIsActiveAndAnnouncementAtBefore(isActive,date);
    	listTop.addAll(list);
        return listTop;
    }
}
