package com.yd.dal.mapper.agms;

import com.yd.dal.entity.agms.fortune.*;
import com.yd.dal.entity.customer.AclCustomerFortune;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author xxy
 */
public interface AgmsFortuneMapper {
    /**
     * 通过customerid查询财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     * @param customerIdList customerIds
     * @return 财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     */
    List<CustomerFortuneStatisticalInfo> findFortuneStatisticalByCustomers(List<Long> customerIdList);

    /**
     * 发佣检核列表
     * @param requestVO 过滤条件
     * @return 返回结果
     */
    List<CommissionPayoutStatus> commissionPayoutStatusQuery(@Param("item") CommissionPayoutStatusQueryInfo requestVO);

    /**
     * 通过customerId 和 payId 查询 fortune 信息
     * @param payId payId
     * @return FortunePayToOrderInfo
     */
    List<FortunePayToOrderInfo> fortunePayToOrder(@Param("payId") Long payId);

    /**
     * 经纪人支付列表
     * @param info 过滤条件
     * @return 返回结果
     */
    List<WithdrawLabelInfo> transformForWithdrawLabel(@Param("item")WithdrawQueryInfo info);

    List<AclCustomerFortune> queryLifeFortuneListByOrderIds(List<Long> orderIds);

    List<AclCustomerFortune> findByOrderId(@Param("orderId")Long orderId);

    void save(AclCustomerFortune fortune);

}
