package com.yd.api.user.service.impl;

import com.yd.api.user.vo.UserVO;
import com.yd.dal.entity.user.AclUser;
import com.yd.dal.service.user.AclUserDALService;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("userService")
public class UserServiceImpl implements com.yd.api.user.service.UserService {

    @Autowired
    private AclUserDALService userDALService;

	@Override
	public int deleteByPrimaryKey(Long id) {
		return userDALService.deleteByPrimaryKey(id);
	}

	@Override
	public int insert(UserVO record) {
		AclUser one = new AclUser();
		BeanUtils.copyProperties(record, one);
		
		return userDALService.insert(one);
	}

	@Override
	public int insertSelective(UserVO record) {
		AclUser one = new AclUser();
		BeanUtils.copyProperties(record, one);
		return userDALService.insertSelective(one);
	}

	@Override
	public UserVO selectByPrimaryKey(Long id) {
		AclUser one = new AclUser();
		UserVO record = new UserVO();
		one = userDALService.selectByPrimaryKey(id);
		BeanUtils.copyProperties(one,record);
		return record;
	}

	@Override
	public int updateByPrimaryKeySelective(UserVO record) {
		AclUser one = new AclUser();
		BeanUtils.copyProperties(record, one);
		return userDALService.updateByPrimaryKeySelective(one);
	}

	@Override
	public int updateByPrimaryKey(UserVO record) {
		AclUser one = new AclUser();
		BeanUtils.copyProperties(record, one);
		return userDALService.updateByPrimaryKey(one);
	}

	@Override
	public List<UserVO> findByIds(List<Long> userIdList) {
		List<UserVO> voUserList = new ArrayList<UserVO>();
		
		List<AclUser> daUserList = userDALService.findByIds(userIdList);
		
		for(AclUser one:daUserList)
		{
			UserVO record = new UserVO();
			BeanUtils.copyProperties(one, record);
			voUserList.add(record);
		}
		return voUserList;
	}
   
}
