package com.yd.dal.service.practitioner.impl;

import com.yd.api.practitioner.vo.hiring.PractitionerHiringContractTerms;
import com.yd.dal.entity.practitioner.hiring.*;
import com.yd.dal.mapper.practitioner.PractitionerHiringMapper;
import com.yd.dal.service.practitioner.PractitionerHiringDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author xxy
 */
@Service("practitionerHiringDALService")
public class PractitionerHiringDALServiceImpl implements PractitionerHiringDALService {

    @Resource
    private PractitionerHiringMapper practitionerHiringMapper;

    @Override
    public List<HiringListInfo> findHiringList(Long practitionerId, Long approvingStatus) {
        return practitionerHiringMapper.findHiringList(practitionerId, approvingStatus);
    }

    @Override
    public HiringBasicInfo findHiringBasicInfo(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringBasicInfo(hiringBasicInfoId);
    }

    @Override
    public HiringMemberShip findHiringMemberShip(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringMemberShip(hiringBasicInfoId);
    }

    @Override
    public List<HiringWorkingExperience> findHiringWorkingExperienceList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringWorkingExperienceList(hiringBasicInfoId);
    }

    @Override
    public List<HiringPersonalStatements> findHiringPersonalStatementsList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringPersonalStatementsList(hiringBasicInfoId);
    }

    @Override
    public List<HiringContractTermsConfirms> findHiringContractTermsConfirmsList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringContractTermsConfirmsList(hiringBasicInfoId);
    }

    @Override
    public List<HiringApproveRecords> findHiringApproveRecordsList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringApproveRecordsList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringContractTerms> queryContractTerms() {
        return practitionerHiringMapper.queryContractTerms();
    }
}
