package com.yd.dal.entity.survey;

import java.util.Date;
import lombok.Data;

/**
    * 用户提交的答卷
    */
@Data
public class SurveyCustomerAnswers {
    private Long id;

    /**
    * FK ag_acl_customer.id，收集用户手机注册用户
    */
    private Long customerId;

    /**
    * ag_survey_pages.id
    */
    private Long pageId;

    /**
    * FK ag_po_order.id，调查问卷跟着49块钱的订单走，一单至多一个问卷
    */
    private Long orderId;

    /**
    * ag_survey_questions.id
    */
    private Long questionId;

    /**
    * 选项FK ag_survey_questions.question_name，孩子可能有多个孩子年龄2，孩子年龄3
    */
    private String questionName;

    /**
    * 选项FK ag_survey_options.option_name
    */
    private String optionName;

    /**
    * 用户选择的选项ID，FK ag_survey_options.id
    */
    private Long optionIdSelected;

    /**
    * 档ag_survey_question.option_type为3，4用户输入时
    */
    private String customerInput;

    /**
    * 0=No, 1=Yes
    */
    private Integer isActive;

    /**
    * 创建时间
    */
    private Date createdAt;

    /**
    * 创建人
    */
    private Long createdBy;

    /**
    * 修改时间
    */
    private Date updatedAt;

    /**
    * 修改人
    */
    private Long updatedBy;
}