package com.yd.api.commission;


import com.yd.api.commission.service.LifeCommissionService;
import com.yd.api.commission.vo.lifecommission.CheckComeCommissionRequestVO;
import com.yd.api.commission.vo.lifecommission.CheckComeCommissionResponseVO;
import com.yd.api.commission.vo.lifecommission.ComeCommissionListResponseVO;
import com.yd.api.commission.vo.lifecommission.QueryComeCommissionListRequestVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核实发放寿险经纪人佣金
 */
@RestController
public class LifeCommissionController {
	
	@Autowired
	private LifeCommissionService lifeCommissionService;

	/**
	 * 查询来佣比对列表
	 *
	 * @return
	 */
	@RequestMapping("/queryComeCommissionList")
	public Object queryComeCommissionList(@RequestBody QueryComeCommissionListRequestVO requestVO){
		JsonResult result = new JsonResult();
		ComeCommissionListResponseVO responseVO = lifeCommissionService.queryComeCommissionList(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 来佣比对
	 *
	 * @return
	 */
	@RequestMapping("/updateCommissionCheckStatus")
	public Object updateCommissionCheckStatus(@RequestBody CheckComeCommissionRequestVO requestVO){
		JsonResult result = new JsonResult();
		CheckComeCommissionResponseVO responseVO = lifeCommissionService.updateCommissionCheckStatus(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

}