package com.yd.dal.mapper.marketing;

import com.yd.dal.entity.practitioner.PersonalPEPScore;
import com.yd.dal.entity.practitioner.PersonalSchedule;
import com.yd.dal.entity.practitioner.ScheduleTrack;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

public interface ScheduleTrackMapper {

    void insert(ScheduleTrack schedule);

    List<ScheduleTrack> queryScheduleTrackList(@Param("practitionerId")Long practitionerId, @Param("trackDate")String trackDate);

    int checkTimePeriodConflict(@Param("trackTime")Date trackTime, @Param("taskTimeFrom")String taskTimeFrom,
                                @Param("taskTimeEnd")String taskTimeEnd, @Param("practitionerId")Long practitionerId);

    List<PersonalPEPScore> querySaleRecuitScoreFYC(@Param("list")List<Long> practitionerIdList);

    List<Long> queryTeamAllPractitionerId(@Param("practitionerId")Long practitionerId);

    List<PersonalSchedule> queryPersonalScheduleList(@Param("list")List<Long> practitionerIdList, @Param("trackDate")Date trackDate);

    List<ScheduleTrack> queryPersonalScheduleListByTime(@Param("practitionerId")Long practitionerId, @Param("time")String time, @Param("trackDate")Date trackDate);

    void deleteScheduleTrackById(@Param("scheduleTrackId")Long scheduleTrackId);

    String queryNameByPractitionerId(Long practitionerId);

    int checkIsExist(@Param("practitionerId")Long practitionerId, @Param("trackTime")Date trackTime, @Param("mdDropOptionId")Long mdDropOptionId,
                     @Param("taskTimeFrom")String taskTimeFrom, @Param("taskTimeEnd")String taskTimeEnd);
}

