package com.yd.util.auth;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.result.JsonResult;
import com.yd.util.auth.service.AuthorizeService;
import com.yd.util.auth.vo.CheckTokenRequestVO;
import com.yd.util.auth.vo.CheckTokenResponseVO;
import com.yd.util.auth.vo.ObtainTokenRequestVO;
import com.yd.util.auth.vo.ObtainTokenResponseVO;
import com.yd.util.config.ZHBErrorConfig;

@RestController
@RequestMapping("/authorize")
public class AuthorizeController {
	@Autowired
	private AuthorizeService authorizeService;
	/**
	 * 获取TOKEN接口
	 * @param requestVO
	 * @return
	 */
	@RequestMapping("/obtainToken")
	public Object obtainToken(@RequestBody ObtainTokenRequestVO requestVO){
		JsonResult result = new JsonResult();
		ObtainTokenResponseVO responseVO = authorizeService.obtainToken(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}
	/**
	 * 校验TOKEN接口
	 * @param requestVO
	 * @return
	 */
	@RequestMapping("/checkToken")
	public Object checkToken(@RequestBody CheckTokenRequestVO requestVO){
		JsonResult result = new JsonResult();
		CheckTokenResponseVO responseVO = authorizeService.checkToken(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}
	
	@RequestMapping("/checkavailable")
	public Object checkAvailable(){
		JsonResult result = new JsonResult();
		
		result.setMessage(ZHBErrorConfig.getErrorInfo("800000"));
		result.setSuccess(true);
		return result;
	}

}
