package com.yd.dal.service.marketing;

import com.yd.dal.entity.marketing.MktLeadsAssignedTrack;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public interface MktLeadsAssignedTrackDALService {
    List<MktLeadsAssignedTrack> findByMktLeadsAssignedTrack(MktLeadsAssignedTrack mktLeadsAssignedTrack);

    void saveTrack(MktLeadsAssignedTrack track);

    void updateTrack(MktLeadsAssignedTrack track);

    List<MktLeadsAssignedTrack> findByTrackTimeForNew(MktLeadsAssignedTrack mktLeadsAssignedTrack);

    /**
     * 计算经纪人得分统计
     * @param practitionerIds  经纪人id的list
     * @return 返回他们的分数统计 1.天得分 2.周得分 3.月得分
     */
    HashMap<String, BigDecimal> totalStatisticsForTeam(List<Long> practitionerIds);

    MktLeadsAssignedTrack findByListNotesForCustomerId(Long customerId);
}
