package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.service.AgmsPractitionerService;
import com.yd.api.agms.vo.practitioner.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclPractitionerFileSharing;
import com.yd.dal.service.agms.AgmsPractitionerDALService;
import com.yd.dal.service.customer.AclPractitionerFileSharingDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author xxy
 */
@Service("agmsPractitionerService")
public class AgmsPractitionerServiceImpl implements AgmsPractitionerService {

    @Autowired
    private AclPractitionerFileSharingDALService aclPractitionerFileSharingDalService;
    @Autowired
    private AgmsPractitionerDALService agmsPractitionerDALService;

    @Override
    public PractitionerFileSharingSaveResponseVO practitionerFileSharingSave(PractitionerFileSharingSaveRequestVO requestVO) {
        PractitionerFileSharingSaveResponseVO responseVO = new PractitionerFileSharingSaveResponseVO();
        AclPractitionerFileSharing fileSharing = new AclPractitionerFileSharing();
        BeanUtils.copyProperties(requestVO,fileSharing);
        fileSharing.setUpdatedBy(requestVO.getLoginId());
        Long id = aclPractitionerFileSharingDalService.saveOrUpdate(fileSharing);
        responseVO.setId(id);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public PractitionerFileSharingListResponseVO practitionerFileSharingList(PractitionerFileSharingListRequestVO requestVO) {
        PractitionerFileSharingListResponseVO responseVO = new PractitionerFileSharingListResponseVO();
        Long[] mdDropOptionIds=null;
        if (!CommonUtil.isNullOrBlank(requestVO.getMdDropOptionId())){
            mdDropOptionIds=(Long[]) ConvertUtils.convert(requestVO.getMdDropOptionId().split(","),Long.class);
        }
        PageInfo<PractitionerFileSharing> practitionerFileShares = agmsPractitionerDALService.practitionerFileSharingList(requestVO.getId(),
                requestVO.getShareCode(),
                mdDropOptionIds,
                requestVO.getIsActive(),
                requestVO.getPractitionerFileShares().getPageNum(),
                requestVO.getPractitionerFileShares().getPageSize());
        responseVO.setPractitionerFileShares(practitionerFileShares);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
