package com.yd.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpUtil {
    /**
     * 通过url取得文件返回InputStream类型数据
     *
     */
    public static Map<String,Object> getInput(String path) {
        URL url = null;
        InputStream is =null;
        boolean success=true;
        String message="下载文件成功";
        Map<String,Object> resp=new HashMap<>();

        try {
            url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();//利用HttpURLConnection对象,我们可以从网络中获取网页数据.
            conn.setDoInput(true);
            conn.connect();
            is = conn.getInputStream();	//得到网络返回的输入流
        } catch (IOException e) {
            success=false;
            message="下载文件失败";
        } finally {
            resp.put("is",is);
            resp.put("message",message);
            resp.put("success",success);
            return resp;
        }
    }
}
