package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_customer_share
 * @author 
 */
@Data
public class AclCustomerShare implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 规则层级 1-insurer 2-product 3-plan
     */
    private Integer configLevel;

    /**
     * 产品ID, FK ag_product.id
     */
    private Long productId;

    /**
     * 方案ID
     */
    private Long planId;

    /**
     * 猛哥方案订单ID
     */
    private Long orderId;

    /**
     * 分享码
     */
    private String shareCode;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * assigned account id
     */
    private String accountId;

    /**
     * 目的地类型
     */
    private Integer destinationType;

    /**
     * 目的地ID
     */
    private Long destinationId;

    /**
     * 1. list  2. confirm  3. order 4.non-product
     */
    private Integer shareType;

    /**
     * 1. ios, 2.android 3.windows 4. mac os  5. Linux  6. other 
     */
    private Integer os;

    /**
     * 1. wechat  2. wechat friend 3.QQ  4. QZone  5.weibo 
     */
    private Integer channel;

    /**
     * entire url of shared link
     */
    private String url;

    /**
     * 参数过多直接存参数的JSON字符串
     */
    private String jsonParams;

    /**
     * 存试算结果的JSON字符串tableRateDetails
     */
    private String jsonParamsCoverageInfo;

    /**
     * 0=No, 1=Yes
     */
    private Long isOrder;

    /**
     * 起保日期
     */
    private Date effectiveStartDate;

    /**
     * 终保日期
     */
    private Date effectiveEndDate;

    /**
     * 成年人数目
     */
    private Integer adultCount;

    /**
     * 未成年人数目
     */
    private Integer childCount;

    /**
     * 老年人数目
     */
    private Integer eldCount;

    /**
     * 天数
     */
    private Integer dayCount;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * 修改人
     */
    private Long updatedBy;

    /**
     * 名宿无忧房间数量
     */
    private String levelCodeForBuilding;

    private static final long serialVersionUID = 1L;
}