package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerPotentialAssignedTrack;
import com.yd.dal.mapper.customer.AclPractitionerPotentialAssignedTrackMapper;
import com.yd.dal.service.customer.AclPractitionerPotentialAssignedTrackDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("aclPractitionerPotentialAssignedTrackDALService")
public class AclPractitionerPotentialAssignedTrackDALServiceImpl implements AclPractitionerPotentialAssignedTrackDALService {

    @Autowired
    private AclPractitionerPotentialAssignedTrackMapper aclPractitionerPotentialAssignedTrackMapper;
    @Override
    public void saveAll(List<AclPractitionerPotentialAssignedTrack> potentialAssignedTrackList) {
        aclPractitionerPotentialAssignedTrackMapper.insertList(potentialAssignedTrackList);
    }

    @Override
    public List<AclPractitionerPotentialAssignedTrack> findByPractitionerIdAndPotentialIdAndTrackStatusId(Long practitionerId, Long potentialId, Long trackStatusId, Date trackDate) {
        return aclPractitionerPotentialAssignedTrackMapper.findByPractitionerIdAndPotentialIdAndTrackStatusId(practitionerId,potentialId,trackStatusId,trackDate);
    }

    @Override
    public void save(AclPractitionerPotentialAssignedTrack assignedTrack) {
        aclPractitionerPotentialAssignedTrackMapper.insertSelective(assignedTrack);
    }

    @Override
    public List<AclPractitionerPotentialAssignedTrack> findByPotentialIdAndIsLasted(Long potentialId, int isLasted) {
        return aclPractitionerPotentialAssignedTrackMapper.findByPotentialIdAndIsLasted(potentialId,isLasted);
    }

    @Override
    public void updateAll(List<AclPractitionerPotentialAssignedTrack> assignedTrackUpdateList) {
        for(AclPractitionerPotentialAssignedTrack item : assignedTrackUpdateList){
            aclPractitionerPotentialAssignedTrackMapper.updateByPrimaryKeySelective(item);
        }
    }

    @Override
    public List<AclPractitionerPotentialAssignedTrack> findByPractitionerIdAndPotentialId(Long practitionerId, Long potentialId) {
        return aclPractitionerPotentialAssignedTrackMapper.findByPractitionerIdAndPotentialId(practitionerId,potentialId);
    }
}
