package com.yd.rmi.tencent.wechat.vo;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WxUserInfo {

	private String subscribe;//用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息
	private String openid;	//普通用户的标识，对当前开发者帐号唯一
	private String nickname;	//普通用户昵称
	private String sex;	//普通用户性别，1为男性，2为女性
	private String province;	//普通用户个人资料填写的省份
	private String city;	//普通用户个人资料填写的城市
	private String country;	//国家，如中国为CN
	private String headimgurl;	//用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空
	private String[] privilege;	//用户特权信息，json数组，如微信沃卡用户为（chinaunicom）
	private String unionid;	//用户统一标识。针对一个微信开放平台帐号下的应用，同一用户的unionid是唯一的
	private String language;//语言
	private String errcode;//错误代码
	private String errmsg;//错误信息
	private String subscribeTime;//用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
	private String remark;//公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注
	private String groupid;//用户所在的分组ID（兼容旧的用户分组接口）
	private String[] tagidList;//用户被打上的标签ID列表
	private String subscribeScene;//返回用户关注的渠道来源，ADD_SCENE_SEARCH 公众号搜索，ADD_SCENE_ACCOUNT_MIGRATION 公众号迁移，ADD_SCENE_PROFILE_CARD 名片分享，ADD_SCENE_QR_CODE 扫描二维码，ADD_SCENEPROFILE LINK 图文页内名称点击，ADD_SCENE_PROFILE_ITEM 图文页右上角菜单，ADD_SCENE_PAID 支付后关注，ADD_SCENE_OTHERS 其他
	private String qrScene;//二维码扫码场景（开发者自定义）
	private String qrSceneStr;//二维码扫码场景描述（开发者自定义）

	/**
	 * @param openid	普通用户的标识，对当前开发者帐号唯一
	 */
	public void setOpenid(String openid) {
		this.openid = openid;
	}

	/**
	 * @return	openid	普通用户的标识，对当前开发者帐号唯一
	 */
	public String getOpenid() {
		return openid;
	}

	/**
	 * @param nickname	普通用户昵称
	 */
	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	/**
	 * @return	nickname	普通用户昵称
	 */
	public String getNickname() {
		return nickname;
	}

	/**
	 * @param sex	普通用户性别，1为男性，2为女性
	 */
	public void setSex(String sex) {
		this.sex = sex;
	}

	/**
	 * @return	sex	普通用户性别，1为男性，2为女性
	 */
	public String getSex() {
		return sex;
	}

	/**
	 * @param province	普通用户个人资料填写的省份
	 */
	public void setProvince(String province) {
		this.province = province;
	}

	/**
	 * @return	province	普通用户个人资料填写的省份
	 */
	public String getProvince() {
		return province;
	}

	/**
	 * @param city	普通用户个人资料填写的城市
	 */
	public void setCity(String city) {
		this.city = city;
	}

	/**
	 * @return	city	普通用户个人资料填写的城市
	 */
	public String getCity() {
		return city;
	}

	/**
	 * @param country	国家，如中国为CN
	 */
	public void setCountry(String country) {
		this.country = country;
	}

	/**
	 * @return	country	国家，如中国为CN
	 */
	public String getCountry() {
		return country;
	}

	/**
	 * @param headimgurl	用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空
	 */
	public void setHeadimgurl(String headimgurl) {
		this.headimgurl = headimgurl;
	}

	/**
	 * @return	headimgurl	用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空
	 */
	public String getHeadimgurl() {
		return headimgurl;
	}

	/**
	 * @param privilege	用户特权信息，json数组，如微信沃卡用户为（chinaunicom）
	 */
	public void setPrivilege(String[] privilege) {
		this.privilege = privilege;
	}

	/**
	 * @return	privilege	用户特权信息，json数组，如微信沃卡用户为（chinaunicom）
	 */
	public String[] getPrivilege() {
		return privilege;
	}

	/**
	 * @param unionid	用户统一标识。针对一个微信开放平台帐号下的应用，同一用户的unionid是唯一的
	 */
	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}

	/**
	 * @return	unionid	用户统一标识。针对一个微信开放平台帐号下的应用，同一用户的unionid是唯一的
	 */
	public String getUnionid() {
		return unionid;
	}
	/**
	 * @return	language	语言
	 */
	public String getLanguage() {
		return language;
	}
	/**
	 * @param language	语言
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * 获取属性    errcode 错误代码
	 * @return  errcode
	 */
	public String getErrcode() {
		return errcode;
	}

	/**
	 * 属性赋值  errcode 错误代码
	 * @param errcode
	 */
	public void setErrcode(String errcode) {
		this.errcode = errcode;
	}

	/**
	 * 获取属性    errmsg 错误信息
	 * @return  errmsg
	 */
	public String getErrmsg() {
		return errmsg;
	}

	/**
	 * 属性赋值  errmsg	错误信息
	 * @param errmsg
	 */
	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}

	/**
	 * 获取属性    subscribe 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息
	 * @return  subscribe
	 */
	public String getSubscribe() {
		return subscribe;
	}

	/**
	 * 属性赋值  subscribe 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息
	 * @param subscribe
	 */
	public void setSubscribe(String subscribe) {
		this.subscribe = subscribe;
	}

	/**
	 * 获取属性    subscribeTime 	用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
	 * @return  subscribeTime
	 */
	@JsonProperty("subscribe_time")
	public String getSubscribeTime() {
		return subscribeTime;
	}

	/**
	 * 属性赋值  subscribeTime 	用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
	 * @param subscribeTime
	 */
	public void setSubscribeTime(String subscribeTime) {
		this.subscribeTime = subscribeTime;
	}

	/**
	 * 获取属性    remark 公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注
	 * @return  remark
	 */
	public String getRemark() {
		return remark;
	}

	/**
	 * 属性赋值  remark 公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注
	 * @param remark
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}

	/**
	 * 获取属性    groupid 用户所在的分组ID（兼容旧的用户分组接口）
	 * @return  groupid
	 */
	public String getGroupid() {
		return groupid;
	}

	/**
	 * 属性赋值  groupid 用户所在的分组ID（兼容旧的用户分组接口）
	 * @param groupid
	 */
	public void setGroupid(String groupid) {
		this.groupid = groupid;
	}

	/**
	 * 获取属性    tagidList 用户被打上的标签ID列表
	 * @return  tagidList
	 */
	@JsonProperty("tagid_list")
	public String[] getTagidList() {
		return tagidList;
	}

	/**
	 * 属性赋值  tagidList 用户被打上的标签ID列表
	 * @param tagidList
	 */
	public void setTagidList(String[] tagidList) {
		this.tagidList = tagidList;
	}

	/**
	 * 获取属性    subscribeScene 返回用户关注的渠道来源，ADD_SCENE_SEARCH 公众号搜索，ADD_SCENE_ACCOUNT_MIGRATION 公众号迁移，ADD_SCENE_PROFILE_CARD 名片分享，ADD_SCENE_QR_CODE 扫描二维码，ADD_SCENEPROFILE LINK 图文页内名称点击，ADD_SCENE_PROFILE_ITEM 图文页右上角菜单，ADD_SCENE_PAID 支付后关注，ADD_SCENE_OTHERS 其他
	 * @return  subscribeScene
	 */
	@JsonProperty("subscribe_scene")
	public String getSubscribeScene() {
		return subscribeScene;
	}

	/**
	 * 属性赋值  subscribeScene 返回用户关注的渠道来源，ADD_SCENE_SEARCH 公众号搜索，ADD_SCENE_ACCOUNT_MIGRATION 公众号迁移，ADD_SCENE_PROFILE_CARD 名片分享，ADD_SCENE_QR_CODE 扫描二维码，ADD_SCENEPROFILE LINK 图文页内名称点击，ADD_SCENE_PROFILE_ITEM 图文页右上角菜单，ADD_SCENE_PAID 支付后关注，ADD_SCENE_OTHERS 其他
	 * @param subscribeScene
	 */
	public void setSubscribeScene(String subscribeScene) {
		this.subscribeScene = subscribeScene;
	}

	/**
	 * 获取属性    qrScene 	二维码扫码场景（开发者自定义）
	 * @return  qrScene
	 */
	@JsonProperty("qr_scene")
	public String getQrScene() {
		return qrScene;
	}

	/**
	 * 属性赋值  qrScene 	二维码扫码场景（开发者自定义）
	 * @param qrScene
	 */
	public void setQrScene(String qrScene) {
		this.qrScene = qrScene;
	}

	/**
	 * 获取属性    qrSceneStr 二维码扫码场景描述（开发者自定义）
	 * @return  qrSceneStr
	 */
	@JsonProperty("qr_scene_str")
	public String getQrSceneStr() {
		return qrSceneStr;
	}

	/**
	 * 属性赋值  qrSceneStr 二维码扫码场景描述（开发者自定义）
	 * @param qrSceneStr
	 */
	public void setQrSceneStr(String qrSceneStr) {
		this.qrSceneStr = qrSceneStr;
	}

}
