package com.yd.dal.entity.order;

import com.google.common.base.Strings;
import com.yd.util.CommonUtil;

import java.util.Date;

public class CustomerPolicyInfo implements Comparable<CustomerPolicyInfo>{
    private Long orderId;
    private String orderNo;
    private String policyNo;
    private String holderName;
    private String destination;
    private String planName;
    private String productName;
    private String orderDate;
    private String startDate;
    private String endDate;
    private Double referralAmount;
    private Double orderPrice;
    private boolean noPlanProduct;
    private Integer platform;//1、银盾在线，2、EGolden
    private Long planId;
    private Long productId;
    private Long fortuneId;

    public Long getOrderId() {
        return orderId;
    }
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPolicyNo() {
        return policyNo;
    }
    public void setPolicyNo(String policyNo) {
        this.policyNo = policyNo;
    }
    public String getHolderName() {
        return holderName;
    }
    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }
    public String getDestination() {
        return destination;
    }
    public void setDestination(String destination) {
        this.destination = destination;
    }
    public String getPlanName() {
        return planName;
    }
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public String getOrderDate() {
        return orderDate;
    }
    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }
    public String getStartDate() {
        return startDate;
    }
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
    public String getEndDate() {
        return endDate;
    }
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    public Double getReferralAmount() {
        return referralAmount;
    }
    public void setReferralAmount(Double referralAmount) {
        this.referralAmount = referralAmount;
    }
    public Double getOrderPrice() {
        return orderPrice;
    }
    public void setOrderPrice(Double orderPrice) {
        this.orderPrice = orderPrice;
    }
    public String getProductName() {
        return productName;
    }
    public void setProductName(String productName) {
        this.productName = productName;
    }
    public boolean isNoPlanProduct() {
        return noPlanProduct;
    }
    public void setNoPlanProduct(boolean noPlanProduct) {
        this.noPlanProduct = noPlanProduct;
    }

    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getFortuneId() {
        return fortuneId;
    }

    public void setFortuneId(Long fortuneId) {
        this.fortuneId = fortuneId;
    }

    @Override
    public int compareTo(CustomerPolicyInfo o) {
        String orderDate1 = o.getOrderDate();
        if(!Strings.isNullOrEmpty(orderDate) && !Strings.isNullOrEmpty(orderDate1)){
            Date orderDateDT = CommonUtil.stringParseDate(orderDate,"yyyy-MM-dd HH:mm:ss");
            Date orderDate1DT = CommonUtil.stringParseDate(orderDate1,"yyyy-MM-dd HH:mm:ss");
            if(orderDate1DT != null && orderDateDT != null){
                return orderDate1DT.compareTo(orderDateDT);
            }else{
                return  0;
            }
        }else{
            return 0;
        }
    }

}
