package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_channel
 * @author 
 */
@Data
public class AgAclChannel implements Serializable {
    /**
     * serial id
     */
    private Long id;

    private Long customerId;

    /**
     * channel's code
     */
    private String code;

    /**
     * Chinese Name
     */
    private String name;

    /**
     * English name
     */
    private String nameEn;

    /**
     * 0000-00-00
     */
    private Date effectiveStartDate;

    /**
     * 0000-00-00
     */
    private Date effectiveEndDate;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    private BigDecimal referralRate;

    private String contactName;

    private String contactNo;

    private String contactEmail;

    private String contactAddress;

    private String taxNo;

    /**
     * 授权方案列表
     */
    private String grantPlans;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * 修改人
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}