package com.yd.rmi.n22.policy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.rmi.n22.common.utils.N22Utils;
import com.yd.rmi.n22.policy.pojo.policydetail.PolicyDetailQueryRequestBody;
import com.yd.rmi.n22.policy.pojo.policydetail.PolicyDetailQueryResponseVO;
import com.yd.rmi.n22.policy.pojo.policylist.PolicyListQueryRequestBody;
import com.yd.rmi.n22.policy.pojo.policylist.PolicyListQueryResponseVO;
import com.yd.rmi.n22.policy.service.N22PolicyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.UUID;

@Service
public class N22PolicyServiceImpl implements N22PolicyService {
    private final static Logger logger = LoggerFactory.getLogger(N22PolicyServiceImpl.class);

    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public PolicyListQueryResponseVO policyList(PolicyListQueryRequestBody requestBody) {
        JSONObject obj = new JSONObject(); //传参
        PolicyListQueryResponseVO rObj; //返回结果

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", requestBody);
        logger.info("N22查询保单列表请求报文："+obj.toString());


        String url = systemConfigService.getSingleConfigValue("N22_URL_Policy_List ");
        String result = N22Utils.postTransaction(url, obj.toString());

        logger.info("N22查询保单列表响应报文："+result);
        rObj = JSONObject.parseObject(result, PolicyListQueryResponseVO.class);

        return rObj;
    }

    @Override
    public PolicyDetailQueryResponseVO policyInfo(PolicyDetailQueryRequestBody requestBody) {
        JSONObject obj = new JSONObject(); //传参
        PolicyDetailQueryResponseVO rObj; //返回结果

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", requestBody);
        logger.info("N22查询保单详情请求报文："+obj.toString());

        String url = systemConfigService.getSingleConfigValue("N22_URL_Policy_Info ");
        String result = N22Utils.postTransaction(url, obj.toString());

        logger.info("N22查询保单详情响应报文："+result);
        rObj = JSONObject.parseObject(result, PolicyDetailQueryResponseVO.class);

        return rObj;
    }
}
