package com.yd.dal.mapper.practitioner;

import com.yd.api.practitioner.vo.hiring.PractitionerHiringContractTerms;
import com.yd.dal.entity.practitioner.hiring.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author xxy
 */
public interface PractitionerHiringMapper {
    /**
     * 通过经纪人id查询此人审批的报聘经纪人
     * @param practitionerId 经纪人id
     * @return 返回结果
     */
    List<HiringListInfo> findHiringList(@Param("practitionerId")Long practitionerId, @Param("approvingStatus")Long approvingStatus);
    /**
     * 经纪人审批基本信息
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    HiringBasicInfo findHiringBasicInfo(Long hiringBasicInfoId);
    /**
     * 审批经纪人关系
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    HiringMemberShip findHiringMemberShip(Long hiringBasicInfoId);
    /**
     * 审批经纪人工作经历
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringWorkingExperience> findHiringWorkingExperienceList(Long hiringBasicInfoId);
    /**
     * 经纪人申请名目
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringPersonalStatements> findHiringPersonalStatementsList(Long hiringBasicInfoId);
    /**
     * 经纪人合同条款是否同意
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringContractTermsConfirms> findHiringContractTermsConfirmsList(Long hiringBasicInfoId);
    /**
     * 已审批结果
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringApproveRecords> findHiringApproveRecordsList(Long hiringBasicInfoId);

    List<PractitionerHiringContractTerms> queryContractTerms();

    /**
     * ydLife查询当前经纪人已通过或拒绝的报聘记录
     * @param practitionerId
     * @param approvingStatus
     * @return
     */
    List<HiringListInfo> queryHandledList(@Param("practitionerId")Long practitionerId, @Param("approvingStatus")int approvingStatus);

    List<HiringListInfo> queryMentorUnhandledList(Long practitionerId);

    List<HiringListInfo> querySystemOwnerUnhandledList(Long practitionerId);
}
