package com.yd.dal.service.practitioner.impl;

import com.yd.api.practitioner.vo.hiring.PractitionerHiringContractTerms;
import com.yd.dal.entity.customer.CustomerFileUpload;
import com.yd.dal.entity.customer.practitioner.PractitionerInfo;
import com.yd.dal.entity.practitioner.hiring.*;
import com.yd.dal.mapper.customer.AclPractitionerHiringMembershipMapper;
import com.yd.dal.mapper.practitioner.PractitionerHiringMapper;
import com.yd.dal.service.customer.AclFileUploadDALService;
import com.yd.dal.service.customer.AclPractitionerDALService;
import com.yd.dal.service.practitioner.PractitionerHiringDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author xxy
 */
@Service("practitionerHiringDALService")
public class PractitionerHiringDALServiceImpl implements PractitionerHiringDALService {

    @Resource
    private PractitionerHiringMapper practitionerHiringMapper;
    @Autowired
    private AclPractitionerDALService aclPractitionerDALService;
    @Autowired
    private AclFileUploadDALService aclFileUploadDALService;
    @Autowired
    private AclPractitionerHiringMembershipMapper membershipMapper;

    @Override
    public List<HiringListInfo> findHiringList(Long practitionerId, Long approvingStatus) {
        return practitionerHiringMapper.findHiringList(practitionerId, approvingStatus);
    }

    @Override
    public HiringBasicInfo findHiringBasicInfo(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringBasicInfo(hiringBasicInfoId);
    }

    @Override
    public HiringMemberShip findHiringMemberShip(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringMemberShip(hiringBasicInfoId);
    }

    @Override
    public List<HiringWorkingExperience> findHiringWorkingExperienceList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringWorkingExperienceList(hiringBasicInfoId);
    }

    @Override
    public List<HiringPersonalStatements> findHiringPersonalStatementsList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringPersonalStatementsList(hiringBasicInfoId);
    }

    @Override
    public List<HiringContractTermsConfirms> findHiringContractTermsConfirmsList(Long hiringBasicInfoId) {
        return practitionerHiringMapper.findHiringContractTermsConfirmsList(hiringBasicInfoId);
    }

    @Override
    public List<HiringApproveRecords> findHiringApproveRecordsList(Long hiringBasicInfoId) {
        List<HiringApproveRecords> records = practitionerHiringMapper.findHiringApproveRecordsList(hiringBasicInfoId);
        PractitionerInfo practitionerInfo;
        CustomerFileUpload fileUpload;
        String imagePath;
        String levelName;
        for (HiringApproveRecords item : records) {
            // 获取职级
            practitionerInfo = aclPractitionerDALService.findPractitionerInfoByPractitionerId(item.getApprovingPractitionerId());
            levelName = (practitionerInfo != null) ? practitionerInfo.getLevelName() : null;
            // 获取头像
            fileUpload = aclFileUploadDALService.findFilePathInfo(1, 1, item.getApprovingPractitionerId());
            imagePath = (fileUpload != null) ? fileUpload.getFilePath() : null;

            item.setHeadImagePath(imagePath);
            item.setLevelName(levelName);
        }
        return records;
    }

    @Override
    public List<PractitionerHiringContractTerms> queryContractTerms() {
        return practitionerHiringMapper.queryContractTerms();
    }

    @Override
    public List<HiringListInfo> queryHandledList(Long practitionerId, int approvingStatus) {
        return practitionerHiringMapper.queryHandledList(practitionerId, approvingStatus);
    }

    @Override
    public List<HiringListInfo> queryUnhandledList(Long practitionerId) {
        // 查询审批身份 0.既是辅导人又是团队长  1.辅导人  2.团队长
        int approvalIdentity = this.queryApprovalIdentity(practitionerId);

        List<HiringListInfo> resultList = null;
        if (approvalIdentity == 1) {
            resultList = practitionerHiringMapper.queryMentorUnhandledList(practitionerId);
        } else if (approvalIdentity == 2) {
            resultList = practitionerHiringMapper.querySystemOwnerUnhandledList(practitionerId);
        } else {
            List<HiringListInfo> list1 = practitionerHiringMapper.queryMentorUnhandledList(practitionerId);
            List<HiringListInfo> list2 = practitionerHiringMapper.querySystemOwnerUnhandledList(practitionerId);
            resultList.addAll(list1);
            resultList.addAll(list2);
        }
        return resultList;
    }

    private int queryApprovalIdentity(Long practitionerId) {
        // 审批身份 0.既是辅导人又是团队长  1.辅导人  2.团队长
        int isMentor = membershipMapper.isMentor(practitionerId);
        int isSystemOwner = membershipMapper.isSystemOwner(practitionerId);

        if (isMentor > 0 && isSystemOwner == 0 ) {
            return 1;
        }
        if (isMentor == 0 && isSystemOwner > 0 ) {
            return 2;
        }
        if (isMentor > 0 && isSystemOwner > 0 ) {
            return 0;
        }
        return 1;
    }
}
