package com.yd.dal.service.agms.impl;

import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.mapper.agms.AgmsHiringMapper;
import com.yd.dal.service.agms.AgmsHiringDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxy
 */
@Service("agmsHiringDALService")
public class AgmsHiringDALServiceImpl implements AgmsHiringDALService {

    private AgmsHiringMapper agmsHiringMapper;

    @Autowired
    public void setAgmsHiringMapper(AgmsHiringMapper agmsHiringMapper){
        this.agmsHiringMapper = agmsHiringMapper;
    }

    @Override
    public PractitionerHiringBasicInfo findPractitionerHiringBasicInfo(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringBasicInfo(hiringBasicInfoId);
    }

    @Override
    public PractitionerHiringMemberShip findPractitionerHiringMemberShip(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringMemberShip(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringWorkingExperience> findPractitionerHiringWorkingExperienceList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringWorkingExperienceList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringPersonalStatements> findPractitionerHiringPersonalStatementsList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringPersonalStatementsList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringContractTermsConfirms> findPractitionerHiringContractTermsConfirmsList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringContractTermsConfirmsList(hiringBasicInfoId);
    }

    @Override
    public List<PractitionerHiringApproveRecords> findPractitionerHiringApproveRecordsList(Long hiringBasicInfoId) {
        return agmsHiringMapper.findPractitionerHiringApproveRecordsList(hiringBasicInfoId);
    }
}
