package com.yd.dal.entity.customer;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * fortune record of customer
 */
public class AclCustomerFortune {
    private static final long serialVersionUID = 1L;
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_customer_share.id
     */
    private Long shareId;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * FK ag_po_order.id
     */
    private Long orderId;

    private Date orderDate;

    private BigDecimal orderPrice;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission银盾来佣佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 银盾来佣佣金
     */
    private BigDecimal commissionAmount;

    /**
     * 公告佣金率存百分值
     */
    private BigDecimal fycRate;

    /**
     * 公告佣金
     */
    private BigDecimal fycAmount;

    /**
     * FK ag_acl_channel_referral_rate个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * 多个代理人财富分摊比例
     */
    private BigDecimal shareRate;

    /**
     * %=referral amount / order price
     */
    private BigDecimal referralRate;

    private BigDecimal referralAmount;

    /**
     * 发佣年月
     */
    private String monthPeriod;

    /**
     * 佣金类型
     */
    private String commissionType;

    /**
     * FK ag_md_drop_options.drop_option_code where master = Commission_Type,佣金项目类型编码
     */
    private String dropOptionCode;

    /**
     * 经纪人等级
     */
    private String practitionerLevel;

    /**
     * 0=No, 1=Yes
     */
    private Integer isTax;

    private BigDecimal taxAmount;

    private BigDecimal netAmount;

    /**
     * FK ag_md_mk_campaign.id
     */
    private Long campaignId;

    /**
     * 推广活动
     */
    private String campaignName;

    /**
     * 可提现日期，在生产记录时就算好
     */
    private Date withdrawableDate;

    /**
     * FK ag_md_drop_options.drop_option_code where master = Commission_Payout_Status,佣金发放状态
     */
    private String commissionPayoutStatus;

    /**
     * 发放状态修改时间
     */
    private Date commissionPayoutAt;

    /**
     * FK ag_acl_user.id
     */
    private Long commissionPayoutBy;

    /**
     * FK ag_acl_customer_fortune_withdraw.id 提现表的id
     */
    private Long withdrawedId;

    /**
     * FK ag_acl_customer_fortune_pay.id 支付表的id
     */
    private Long fortunePayedId;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * FK ag_acl_customer.id
     */
    private Long createdBy;

    /**
     * Gets the value of id. *
     *
     * @return the value of id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id. *
     * <p>You can use getId() to get the value of id</p>
     * * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the value of shareId. *
     *
     * @return the value of shareId
     */
    public Long getShareId() {
        return shareId;
    }

    /**
     * Sets the shareId. *
     * <p>You can use getShareId() to get the value of shareId</p>
     * * @param shareId shareId
     */
    public void setShareId(Long shareId) {
        this.shareId = shareId;
    }

    /**
     * Gets the value of customerId. *
     *
     * @return the value of customerId
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * Sets the customerId. *
     * <p>You can use getCustomerId() to get the value of customerId</p>
     * * @param customerId customerId
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * Gets the value of orderId. *
     *
     * @return the value of orderId
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * Sets the orderId. *
     * <p>You can use getOrderId() to get the value of orderId</p>
     * * @param orderId orderId
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    /**
     * Gets the value of orderDate. *
     *
     * @return the value of orderDate
     */
    public Date getOrderDate() {
        return orderDate;
    }

    /**
     * Sets the orderDate. *
     * <p>You can use getOrderDate() to get the value of orderDate</p>
     * * @param orderDate orderDate
     */
    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    /**
     * Gets the value of orderPrice. *
     *
     * @return the value of orderPrice
     */
    public BigDecimal getOrderPrice() {
        return orderPrice;
    }

    /**
     * Sets the orderPrice. *
     * <p>You can use getOrderPrice() to get the value of orderPrice</p>
     * * @param orderPrice orderPrice
     */
    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    /**
     * Gets the value of commissionRate. *
     *
     * @return the value of commissionRate
     */
    public BigDecimal getCommissionRate() {
        return commissionRate;
    }

    /**
     * Sets the commissionRate. *
     * <p>You can use getCommissionRate() to get the value of commissionRate</p>
     * * @param commissionRate commissionRate
     */
    public void setCommissionRate(BigDecimal commissionRate) {
        this.commissionRate = commissionRate;
    }

    /**
     * Gets the value of commissionAmount. *
     *
     * @return the value of commissionAmount
     */
    public BigDecimal getCommissionAmount() {
        return commissionAmount;
    }

    /**
     * Sets the commissionAmount. *
     * <p>You can use getCommissionAmount() to get the value of commissionAmount</p>
     * * @param commissionAmount commissionAmount
     */
    public void setCommissionAmount(BigDecimal commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /**
     * Gets the value of fycRate. *
     *
     * @return the value of fycRate
     */
    public BigDecimal getFycRate() {
        return fycRate;
    }

    /**
     * Sets the fycRate. *
     * <p>You can use getFycRate() to get the value of fycRate</p>
     * * @param fycRate fycRate
     */
    public void setFycRate(BigDecimal fycRate) {
        this.fycRate = fycRate;
    }

    /**
     * Gets the value of fycAmount. *
     *
     * @return the value of fycAmount
     */
    public BigDecimal getFycAmount() {
        return fycAmount;
    }

    /**
     * Sets the fycAmount. *
     * <p>You can use getFycAmount() to get the value of fycAmount</p>
     * * @param fycAmount fycAmount
     */
    public void setFycAmount(BigDecimal fycAmount) {
        this.fycAmount = fycAmount;
    }

    /**
     * Gets the value of gradeCommissionRate. *
     *
     * @return the value of gradeCommissionRate
     */
    public BigDecimal getGradeCommissionRate() {
        return gradeCommissionRate;
    }

    /**
     * Sets the gradeCommissionRate. *
     * <p>You can use getGradeCommissionRate() to get the value of gradeCommissionRate</p>
     * * @param gradeCommissionRate gradeCommissionRate
     */
    public void setGradeCommissionRate(BigDecimal gradeCommissionRate) {
        this.gradeCommissionRate = gradeCommissionRate;
    }

    /**
     * Gets the value of shareRate. *
     *
     * @return the value of shareRate
     */
    public BigDecimal getShareRate() {
        return shareRate;
    }

    /**
     * Sets the shareRate. *
     * <p>You can use getShareRate() to get the value of shareRate</p>
     * * @param shareRate shareRate
     */
    public void setShareRate(BigDecimal shareRate) {
        this.shareRate = shareRate;
    }

    /**
     * Gets the value of referralRate. *
     *
     * @return the value of referralRate
     */
    public BigDecimal getReferralRate() {
        return referralRate;
    }

    /**
     * Sets the referralRate. *
     * <p>You can use getReferralRate() to get the value of referralRate</p>
     * * @param referralRate referralRate
     */
    public void setReferralRate(BigDecimal referralRate) {
        this.referralRate = referralRate;
    }

    /**
     * Gets the value of referralAmount. *
     *
     * @return the value of referralAmount
     */
    public BigDecimal getReferralAmount() {
        return referralAmount;
    }

    /**
     * Sets the referralAmount. *
     * <p>You can use getReferralAmount() to get the value of referralAmount</p>
     * * @param referralAmount referralAmount
     */
    public void setReferralAmount(BigDecimal referralAmount) {
        this.referralAmount = referralAmount;
    }

    /**
     * Gets the value of monthPeriod. *
     *
     * @return the value of monthPeriod
     */
    public String getMonthPeriod() {
        return monthPeriod;
    }

    /**
     * Sets the monthPeriod. *
     * <p>You can use getMonthPeriod() to get the value of monthPeriod</p>
     * * @param monthPeriod monthPeriod
     */
    public void setMonthPeriod(String monthPeriod) {
        this.monthPeriod = monthPeriod;
    }

    /**
     * Gets the value of commissionType. *
     *
     * @return the value of commissionType
     */
    public String getCommissionType() {
        return commissionType;
    }

    /**
     * Sets the commissionType. *
     * <p>You can use getCommissionType() to get the value of commissionType</p>
     * * @param commissionType commissionType
     */
    public void setCommissionType(String commissionType) {
        this.commissionType = commissionType;
    }

    /**
     * Gets the value of dropOptionCode. *
     *
     * @return the value of dropOptionCode
     */
    public String getDropOptionCode() {
        return dropOptionCode;
    }

    /**
     * Sets the dropOptionCode. *
     * <p>You can use getDropOptionCode() to get the value of dropOptionCode</p>
     * * @param dropOptionCode dropOptionCode
     */
    public void setDropOptionCode(String dropOptionCode) {
        this.dropOptionCode = dropOptionCode;
    }

    /**
     * Gets the value of practitionerLevel. *
     *
     * @return the value of practitionerLevel
     */
    public String getPractitionerLevel() {
        return practitionerLevel;
    }

    /**
     * Sets the practitionerLevel. *
     * <p>You can use getPractitionerLevel() to get the value of practitionerLevel</p>
     * * @param practitionerLevel practitionerLevel
     */
    public void setPractitionerLevel(String practitionerLevel) {
        this.practitionerLevel = practitionerLevel;
    }

    /**
     * Gets the value of isTax. *
     *
     * @return the value of isTax
     */
    public Integer getIsTax() {
        return isTax;
    }

    /**
     * Sets the isTax. *
     * <p>You can use getIsTax() to get the value of isTax</p>
     * * @param isTax isTax
     */
    public void setIsTax(Integer isTax) {
        this.isTax = isTax;
    }

    /**
     * Gets the value of taxAmount. *
     *
     * @return the value of taxAmount
     */
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    /**
     * Sets the taxAmount. *
     * <p>You can use getTaxAmount() to get the value of taxAmount</p>
     * * @param taxAmount taxAmount
     */
    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    /**
     * Gets the value of netAmount. *
     *
     * @return the value of netAmount
     */
    public BigDecimal getNetAmount() {
        return netAmount;
    }

    /**
     * Sets the netAmount. *
     * <p>You can use getNetAmount() to get the value of netAmount</p>
     * * @param netAmount netAmount
     */
    public void setNetAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
    }

    /**
     * Gets the value of campaignId. *
     *
     * @return the value of campaignId
     */
    public Long getCampaignId() {
        return campaignId;
    }

    /**
     * Sets the campaignId. *
     * <p>You can use getCampaignId() to get the value of campaignId</p>
     * * @param campaignId campaignId
     */
    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    /**
     * Gets the value of campaignName. *
     *
     * @return the value of campaignName
     */
    public String getCampaignName() {
        return campaignName;
    }

    /**
     * Sets the campaignName. *
     * <p>You can use getCampaignName() to get the value of campaignName</p>
     * * @param campaignName campaignName
     */
    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    /**
     * Gets the value of withdrawableDate. *
     *
     * @return the value of withdrawableDate
     */
    public Date getWithdrawableDate() {
        return withdrawableDate;
    }

    /**
     * Sets the withdrawableDate. *
     * <p>You can use getWithdrawableDate() to get the value of withdrawableDate</p>
     * * @param withdrawableDate withdrawableDate
     */
    public void setWithdrawableDate(Date withdrawableDate) {
        this.withdrawableDate = withdrawableDate;
    }

    /**
     * Gets the value of commissionPayoutStatus. *
     *
     * @return the value of commissionPayoutStatus
     */
    public String getCommissionPayoutStatus() {
        return commissionPayoutStatus;
    }

    /**
     * Sets the commissionPayoutStatus. *
     * <p>You can use getCommissionPayoutStatus() to get the value of commissionPayoutStatus</p>
     * * @param commissionPayoutStatus commissionPayoutStatus
     */
    public void setCommissionPayoutStatus(String commissionPayoutStatus) {
        this.commissionPayoutStatus = commissionPayoutStatus;
    }

    /**
     * Gets the value of commissionPayoutAt. *
     *
     * @return the value of commissionPayoutAt
     */
    public Date getCommissionPayoutAt() {
        return commissionPayoutAt;
    }

    /**
     * Sets the commissionPayoutAt. *
     * <p>You can use getCommissionPayoutAt() to get the value of commissionPayoutAt</p>
     * * @param commissionPayoutAt commissionPayoutAt
     */
    public void setCommissionPayoutAt(Date commissionPayoutAt) {
        this.commissionPayoutAt = commissionPayoutAt;
    }

    /**
     * Gets the value of commissionPayoutBy. *
     *
     * @return the value of commissionPayoutBy
     */
    public Long getCommissionPayoutBy() {
        return commissionPayoutBy;
    }

    /**
     * Sets the commissionPayoutBy. *
     * <p>You can use getCommissionPayoutBy() to get the value of commissionPayoutBy</p>
     * * @param commissionPayoutBy commissionPayoutBy
     */
    public void setCommissionPayoutBy(Long commissionPayoutBy) {
        this.commissionPayoutBy = commissionPayoutBy;
    }

    /**
     * Gets the value of withdrawedId. *
     *
     * @return the value of withdrawedId
     */
    public Long getWithdrawedId() {
        return withdrawedId;
    }

    /**
     * Sets the withdrawedId. *
     * <p>You can use getWithdrawedId() to get the value of withdrawedId</p>
     * * @param withdrawedId withdrawedId
     */
    public void setWithdrawedId(Long withdrawedId) {
        this.withdrawedId = withdrawedId;
    }

    /**
     * Gets the value of fortunePayedId. *
     *
     * @return the value of fortunePayedId
     */
    public Long getFortunePayedId() {
        return fortunePayedId;
    }

    /**
     * Sets the fortunePayedId. *
     * <p>You can use getFortunePayedId() to get the value of fortunePayedId</p>
     * * @param fortunePayedId fortunePayedId
     */
    public void setFortunePayedId(Long fortunePayedId) {
        this.fortunePayedId = fortunePayedId;
    }

    /**
     * Gets the value of createdAt. *
     *
     * @return the value of createdAt
     */
    public Date getCreatedAt() {
        return createdAt;
    }

    /**
     * Sets the createdAt. *
     * <p>You can use getCreatedAt() to get the value of createdAt</p>
     * * @param createdAt createdAt
     */
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * Gets the value of createdBy. *
     *
     * @return the value of createdBy
     */
    public Long getCreatedBy() {
        return createdBy;
    }

    /**
     * Sets the createdBy. *
     * <p>You can use getCreatedBy() to get the value of createdBy</p>
     * * @param createdBy createdBy
     */
    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }
}