package com.yd.dal.service.marketing;

import com.yd.dal.entity.marketing.MktLeadsAssigneds;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public interface MktLeadsAssignedsDALService {
    List<MktLeadsAssigneds> findByMktLeadsAssigneds(MktLeadsAssigneds mktLeadsAssigneds);

    MktLeadsAssigneds findByLeadsAssignedId(Long leadsAssignedId);

    void updateMktLeadsAssigneds(MktLeadsAssigneds mktLeadsAssigneds);

    void save(MktLeadsAssigneds assigneds);

    List<MktLeadsAssigneds> findByPractitionerIdAndThisWeek(Long practitionerId);

    /**
     * 统计这些经纪人id本周一共新增多少商机
     */
    Integer countPractitionerIdsAndThisWeek(List<Long> practitionerIds);

    /**
     * 计算年/季/月  首年保费(premium)/佣金(commission)/件数(pieces)  均取至指派表ag_mkt_leads_assigneds
     * ag_mkt_leads_assigned_track跟进记录不可有"拒绝"  md_drop_option_id = 102  (传入)
     */
    HashMap<String, BigDecimal> performanceForecastForTeam(List<Long> practitionerIds,Long refusedId);

    /**
     * 查询该团队所有商机指派,排除以失败的
     * @param practitionerIds
     * @param dropOptionsId
     * @return
     */
    List<MktLeadsAssigneds> selectByPractitionerIdRemoveRefused(List<Long> practitionerIds, Long dropOptionsId);
}
