package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerPotentialGoalsActions;
import com.yd.dal.mapper.customer.AclPractitionerPotentialGoalsActionsMapper;
import com.yd.dal.service.customer.AclPractitionerPotentialGoalsActionsDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("aclPractitionerPotentialGoalsActionsDALService")
public class AclPractitionerPotentialGoalsActionsDALServiceImpl implements AclPractitionerPotentialGoalsActionsDALService {

    @Resource
    private AclPractitionerPotentialGoalsActionsMapper aclPractitionerPotentialGoalsActionsMapper;
    @Override
    public List<AclPractitionerPotentialGoalsActions> findByPractitionerIdAndCurrentYearAndIsActive(Long practitionerId, Integer currentYear, Integer isActive) {
        return aclPractitionerPotentialGoalsActionsMapper.findByPractitionerIdAndCurrentYearAndIsActive(practitionerId,currentYear,isActive);
    }

    @Override
    public void updateAll(List<AclPractitionerPotentialGoalsActions> potentialGoalsActionsListUpdate) {
        for(AclPractitionerPotentialGoalsActions item : potentialGoalsActionsListUpdate){
            aclPractitionerPotentialGoalsActionsMapper.updateByPrimaryKeySelective(item);
        }
    }

    @Override
    public void saveAll(List<AclPractitionerPotentialGoalsActions> potentialGoalsActionsList) {
        aclPractitionerPotentialGoalsActionsMapper.saveAll(potentialGoalsActionsList);
    }
}
