package com.yd.api.practitioner;

import com.yd.api.practitioner.service.PractitionerService;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.recruit.*;
import com.yd.api.practitioner.vo.setting.*;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@RequestMapping("/practitioner")
public class PractitionerController {

    @Autowired
    private PractitionerService practitionerService;

    /**
     * 经纪人登录
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/login")
    public Object practitionerLogin(@RequestBody PractitionerLoginRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerLoginResponseVO responseVO = practitionerService.practitionerLogin(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人（排行榜） + （保费+佣金+件数）查询
     * @param  requestVO 请求数据
     * @return Object
     */
    @RequestMapping("/rank")
    public Object practitionerRank(@RequestBody PractitionerRankRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerRankResponseVO responseVO = practitionerService.practitionerRank(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 查询经纪人的个人设置
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/settingQuery")
    public Object settingQuery(@RequestBody SettingQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SettingQueryResponseVO responseVO = practitionerService.settingQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 保存经纪人的个人设置
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/settingSave")
    public Object mySettingSave(@RequestBody SettingSaveRequestVO requestVO) throws Exception {
        JsonResult result = new JsonResult();
        SettingSaveResponseVO responseVO = practitionerService.settingSave(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 删除经纪人照片
     */
    @RequestMapping("/imgDelete")
    public Object imgDelete(@RequestBody ImgDeleteRequestVO requestVO){
        JsonResult result = new JsonResult();
        ImgDeleteResponseVO responseVO = practitionerService.imgDelete(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    @RequestMapping("/mediaGet")
    public Object mediaGet(@RequestBody MediaGetReqVO requestVO){
        JsonResult result = new JsonResult();
        MediaGetRespVO responseVO = practitionerService.mediaGet(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--新增增员
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruit")
    public Object recruit(@RequestBody RecruitRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitResponseVO responseVO = practitionerService.recruit(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--新增增员记录
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/addRecruitTrack")
    public Object addRecruitTrack(@RequestBody AddRecruitTrackRequestVO requestVO){
        JsonResult result = new JsonResult();
        AddRecruitTrackResponseVO responseVO = practitionerService.addRecruitTrack(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--增员记录查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruitTrackQuery")
    public Object recruitTrackQuery(@RequestBody RecruitTrackQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitTrackQueryResponseVO responseVO = practitionerService.recruitTrackQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--增员列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruitListQuery")
    public Object recruitListQuery(@RequestBody RecruitListRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitListResponseVO responseVO = practitionerService.recruitListQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
}
