package com.yd.api.security;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.result.JsonResult;
import com.yd.api.security.vo.DESCommonVO;
import com.yd.util.deshandler.DESTypeHandler;

@RestController
@RequestMapping(value="/data/security")
public class DataSecurityController {

	@RequestMapping("/dataencrypt")
	public Object encrypt(@RequestBody DESCommonVO requestVO) throws Exception{
		JsonResult result = new JsonResult();
		String resultString = "";
		try {
			DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
			resultString = jpaCryptoConverter.encode((requestVO.getContent()));
			
			requestVO.setEncrypted(resultString);
		} catch (Exception e) {
			e.printStackTrace();
		}

		result.setData(requestVO);
		return result;
	}

    @RequestMapping("/datadecrypt")
	public Object Decrypt(@RequestBody DESCommonVO requestVO) throws Exception{
		JsonResult result = new JsonResult();
		String content = "";

		try {
			DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
			content = jpaCryptoConverter.decode(requestVO.getEncrypted());
			
			requestVO.setContent(content);
		} catch (Exception e) {
			e.printStackTrace();
		}
		result.setData(requestVO);
		return result;
	}
}
